/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.math;

import java.math.BigDecimal;
import net.sf.retrotranslator.runtime.impl.Advanced;

public class _BigDecimal {
    public static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    public static final BigDecimal ONE = BigDecimal.valueOf(1L);
    public static final BigDecimal TEN = BigDecimal.valueOf(10L);

    public static BigDecimal pow(BigDecimal bigDecimal, int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        BigDecimal result = ONE;
        while (n-- > 0) {
            result = result.multiply(bigDecimal);
        }
        return result;
    }

    @Advanced
    public static BigDecimal setScale(BigDecimal bigDecimal, int newScale, int roundingMode) {
        if (newScale >= 0) {
            return bigDecimal.setScale(newScale, roundingMode);
        }
        return bigDecimal.movePointRight(newScale).setScale(0, roundingMode).movePointLeft(newScale);
    }

    public static String toPlainString(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static BigDecimal valueOf(double val) {
        return new BigDecimal(Double.toString(val));
    }

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }
}

