/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import net.sf.retrotranslator.runtime.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.runtime.impl.AnnotationArray;
import net.sf.retrotranslator.runtime.impl.AnnotationValue;
import net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime.impl.EnumValue;
import net.sf.retrotranslator.runtime.impl.GenericDeclarationDescriptor;
import net.sf.retrotranslator.runtime.impl.LazyList;
import net.sf.retrotranslator.runtime.impl.LazyValue;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import net.sf.retrotranslator.runtime.java.lang.reflect.GenericDeclaration_;
import net.sf.retrotranslator.runtime.java.lang.reflect.TypeVariable_;
import net.sf.retrotranslator.runtime.java.lang.reflect.Type_;

public class MethodDescriptor
extends GenericDeclarationDescriptor {
    private String name;
    private String desc;
    private ClassDescriptor classDescriptor;
    private LazyValue method;
    private LazyValue returnType;
    private LazyValue defaultValue;
    private LazyValue constructor;
    private LazyValue genericReturnType;
    private LazyList genericParameterTypes;
    private LazyList genericExceptionTypes;
    private LazyList parameterAnnotations;

    public MethodDescriptor(ClassDescriptor classDescriptor, int access, String name, String desc, String signature) {
        this.classDescriptor = classDescriptor;
        this.access = access;
        this.name = name;
        this.desc = desc;
        if (signature != null) {
            new SignatureReader(signature).accept(this);
        }
        this.returnType = this.createReturnType();
        if (name.equals("<init>")) {
            this.constructor = this.createConstructor();
        } else if (!name.equals("<clinit>")) {
            this.method = this.createMethod();
        }
        this.parameterAnnotations = this.createParameterAnnotations();
    }

    private LazyValue createReturnType() {
        return new LazyValue(this.desc){

            protected Class resolve(String input) {
                return MethodDescriptor.this.getClassByType(Type.getReturnType(input));
            }
        };
    }

    private LazyValue createConstructor() {
        return new LazyValue(this.classDescriptor.getTarget()){

            protected Constructor resolve(Class input) {
                Constructor<?>[] arr$ = input.getDeclaredConstructors();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Constructor<?> constructor = arr$[i$];
                    if (!RuntimeTools.getConstructorDescriptor(constructor).equals(MethodDescriptor.this.desc)) continue;
                    return constructor;
                }
                return null;
            }
        };
    }

    private LazyValue createMethod() {
        return new LazyValue(this.classDescriptor.getTarget()){

            protected Method resolve(Class input) {
                Method[] arr$ = input.getDeclaredMethods();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Method method = arr$[i$];
                    if (!method.getName().equals(MethodDescriptor.this.name) || !Type.getMethodDescriptor(method).equals(MethodDescriptor.this.desc)) continue;
                    return method;
                }
                return null;
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Class getReturnType() {
        return (Class)this.returnType.get();
    }

    public Object getDefaultValue() {
        return this.defaultValue == null ? null : RuntimeTools.cloneNonEmptyArray(this.defaultValue.get());
    }

    public static MethodDescriptor getInstance(Method method) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(method.getDeclaringClass());
        String desc = Type.getMethodDescriptor(method);
        MethodDescriptor methodDescriptor = classDescriptor.getMethodDescriptor(method.getName() + desc);
        if (methodDescriptor == null) {
            methodDescriptor = new MethodDescriptor(classDescriptor, method.getModifiers(), method.getName(), desc, null);
        }
        methodDescriptor.method.provide(method);
        return methodDescriptor;
    }

    public static MethodDescriptor getInstance(Constructor constructor) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(constructor.getDeclaringClass());
        String desc = RuntimeTools.getConstructorDescriptor(constructor);
        MethodDescriptor methodDescriptor = classDescriptor.getMethodDescriptor("<init>" + desc);
        if (methodDescriptor == null) {
            methodDescriptor = new MethodDescriptor(classDescriptor, constructor.getModifiers(), constructor.getName(), desc, null);
        }
        methodDescriptor.constructor.provide(constructor);
        return methodDescriptor;
    }

    public GenericDeclaration_ getTarget() {
        return this.method != null ? (Constructor)this.method.get() : (this.constructor != null ? (Constructor)this.constructor.get() : null);
    }

    public Method getMethod() {
        return this.method == null ? null : (Method)this.method.get();
    }

    public Constructor getConstructor() {
        return this.constructor == null ? null : (Constructor)this.constructor.get();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    protected TypeVariable_ findTypeVariable(String name) {
        TypeVariable_ variable = this.getTypeVariable(name);
        return variable != null ? variable : this.classDescriptor.findTypeVariable(name);
    }

    public Annotation_[][] getParameterAnnotations() {
        return (Annotation_[][])this.parameterAnnotations.getClone();
    }

    private LazyList createParameterAnnotations() {
        return new LazyList(){

            protected Annotation_[] resolve(List input) {
                return MethodDescriptor.this.createAnnotations(input);
            }

            protected Annotation_[][] newArray(int size) {
                return new Annotation_[Type.getArgumentTypes(MethodDescriptor.this.desc).length][];
            }
        };
    }

    public Type_ getGenericReturnType() {
        Object object;
        if (this.genericReturnType == null) {
            object = null;
        } else {
            object = this.genericReturnType.get();
            if (!(object instanceof Class)) {
                object = (Type_)object;
            }
        }
        return object;
    }

    public Type_[] getGenericParameterTypes() {
        return this.genericParameterTypes == null ? null : this.genericParameterTypes.getClone();
    }

    public Type_[] getGenericExceptionTypes() {
        return this.genericExceptionTypes == null ? null : this.genericExceptionTypes.getClone();
    }

    protected Annotation_[] createAnnotations(Annotation_[] declaredAnnotations) {
        return declaredAnnotations;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (!visible) {
            return EMPTY_VISITOR;
        }
        ArrayList<AnnotationValue> values = (ArrayList<AnnotationValue>)this.parameterAnnotations.get(parameter);
        if (values == null) {
            values = new ArrayList<AnnotationValue>();
            this.parameterAnnotations.set(parameter, values);
        }
        AnnotationValue value = new AnnotationValue(desc);
        values.add(value);
        return value;
    }

    public void visit(String name, Object value) {
        this.setDefaultValue(value);
    }

    public void visitEnum(String name, String desc, String value) {
        this.setDefaultValue(new EnumValue(desc, value));
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationValue value = new AnnotationValue(desc);
        this.setDefaultValue(value);
        return value;
    }

    public AnnotationVisitor visitArray(String name) {
        AnnotationArray array = new AnnotationArray();
        this.setDefaultValue(array);
        return array;
    }

    public SignatureVisitor visitParameterType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericParameterTypes == null) {
            this.genericParameterTypes = this.getLazyList();
        }
        this.genericParameterTypes.add(descriptor);
        return descriptor;
    }

    public SignatureVisitor visitReturnType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        this.genericReturnType = this.getLazyType(descriptor);
        return descriptor;
    }

    public SignatureVisitor visitExceptionType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericExceptionTypes == null) {
            this.genericExceptionTypes = this.getLazyList();
        }
        this.genericExceptionTypes.add(descriptor);
        return descriptor;
    }

    private void setDefaultValue(Object o) {
        this.defaultValue = new LazyValue(o){

            protected Object resolve(Object input) {
                return MethodDescriptor.this.resolveValue(input, MethodDescriptor.this.getReturnType(), MethodDescriptor.this);
            }
        };
    }
}

