/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.wme;

import COM.activesw.api.client.BrokerAdminClient;
import COM.activesw.api.client.BrokerEvent;
import COM.activesw.api.client.BrokerException;
import COM.activesw.api.client.BrokerField;
import com.wm.broker.jms.QueueAdmin;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class WMEAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(WMEAdmin.class);
    private static final String QUEUE_LENGTH_FIELD = "queueLength";
    private BrokerAdminClient brokerClient;

    public WMEAdmin(Hermes hermes, BrokerAdminClient brokerClient) {
        super(hermes);
        this.brokerClient = brokerClient;
    }

    private BrokerAdminClient getBrokerClient() throws JMSException {
        if (this.brokerClient == null) {
            throw new HermesException("No BrokerClient");
        }
        return this.brokerClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDepth(DestinationConfig destination) throws JMSException {
        try {
            if (destination.getDomain().intValue() == Domain.QUEUE.getId()) {
                WMEAdmin wMEAdmin = this;
                synchronized (wMEAdmin) {
                    BrokerEvent clientStats = this.getBrokerClient().getClientStatsById(this.getRealDestinationName(destination));
                    BrokerField field = clientStats.getField(QUEUE_LENGTH_FIELD);
                    return Integer.parseInt(field.value.toString());
                }
            }
            throw new HermesException("WebMethods plugin can only get depth in the queue domain.");
        }
        catch (BrokerException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            WMEAdmin wMEAdmin = this;
            synchronized (wMEAdmin) {
                this.brokerClient.disconnect();
                this.brokerClient = null;
            }
        }
        catch (BrokerException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    public Iterator getDestinations() throws JMSException {
        ArrayList rval = new ArrayList();
        return rval.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int truncate(DestinationConfig destination) throws JMSException {
        try {
            QueueAdmin queueAdmin = (QueueAdmin)this.getHermes().getSession().createQueue(destination.getName());
            WMEAdmin wMEAdmin = this;
            synchronized (wMEAdmin) {
                int rval = this.getDepth(destination);
                this.brokerClient.clearClientQueueById(queueAdmin.getName());
                log.debug((Object)("truncated queue=" + queueAdmin.getName() + ", size=" + rval));
                return rval;
            }
        }
        catch (BrokerException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatistics(DestinationConfig destination) throws JMSException {
        TreeMap<String, String> rval = new TreeMap<String, String>();
        try {
            QueueAdmin queueAdmin = (QueueAdmin)this.getHermes().getSession().createQueue(destination.getName());
            WMEAdmin wMEAdmin = this;
            synchronized (wMEAdmin) {
                BrokerEvent clientStats = this.getBrokerClient().getClientStatsById(queueAdmin.getName());
                String[] fieldNames = clientStats.getFieldNames(null);
                for (int i = 0; i < fieldNames.length; ++i) {
                    BrokerField field = clientStats.getField(fieldNames[i]);
                    if (field.value == null) continue;
                    rval.put(fieldNames[i], field.value.toString());
                }
            }
            return rval;
        }
        catch (BrokerException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }
}

