/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.oracle.aq;

import hermes.Hermes;
import hermes.config.DestinationConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import oracle.AQ.AQAgent;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQException;
import oracle.AQ.AQQueue;
import oracle.AQ.AQSession;
import oracle.jms.AQjmsSession;
import org.apache.log4j.Logger;

public class HermesShutdownHook
extends Thread {
    public static final String VERSION_STR = "$Header: /cvs/Integration/dev-tools/rib-aq-hermes-impl/src/hermes/ext/oracle/aq/HermesShutdownHook.java,v 1.1 2009/02/06 03:00:17 polavap Exp $";
    private static final Logger LOG = Logger.getLogger(HermesShutdownHook.class);
    private static final String AQ_DRIVER_CLASS = "oracle.AQ.AQOracleDriver";
    private Hermes hermes = null;
    private static final List<DestinationConfig> list = new ArrayList<DestinationConfig>();

    public HermesShutdownHook(Hermes hermes) {
        this.hermes = hermes;
    }

    public void run() {
        LOG.debug((Object)"Shutting down, removing all the durable subscribers created in this session...");
        try {
            this.removeAllSubscribers();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void addSubscriber(DestinationConfig dConfig) {
        LOG.debug((Object)("Adding Subscriber " + dConfig.getClientID() + " to topic " + dConfig.getName()));
        for (DestinationConfig element : list) {
            if (!dConfig.getName().equals(element.getName())) continue;
            LOG.debug((Object)"Subscriber already in for this topic, returning");
            return;
        }
        list.add(dConfig);
    }

    public void removeAllSubscribers() throws JMSException {
        for (int i = 0; i < list.size(); ++i) {
            DestinationConfig dConfig = list.get(i);
            this.removeSubscriber(dConfig, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(DestinationConfig dConfig, boolean remList) throws JMSException {
        AQSession aqSession = null;
        AQQueue aqQueue = null;
        if (this.hermes.getSession() != null) {
            try {
                AQjmsSession aqjmsSession = (AQjmsSession)this.hermes.getSession();
                Class.forName(AQ_DRIVER_CLASS);
                Connection conn = aqjmsSession.getDBConnection();
                aqSession = AQDriverManager.createAQSession((Object)conn);
                aqQueue = aqSession.getQueue(conn.getMetaData().getUserName(), dConfig.getName());
                AQAgent[] aqAgents = aqQueue.getSubscribers();
                String clientId = dConfig.getClientID();
                clientId = clientId.replaceAll("\"", "");
                LOG.info((Object)("Client id is " + clientId));
                for (int i = 0; i < aqAgents.length; ++i) {
                    LOG.debug((Object)("AQ agent is " + aqAgents[i].getName()));
                    if (!aqAgents[i].getName().equals(clientId.toUpperCase())) continue;
                    LOG.debug((Object)("Before remove subscriber " + aqAgents[i].getName()));
                    aqQueue.removeSubscriber(aqAgents[i]);
                    LOG.info((Object)("Successfully removed durable subscriber " + clientId + " for topic " + dConfig.getName()));
                    break;
                }
            }
            catch (AQException e) {
                String msg = "AQ Exception encountered , check log (hermes.log) for more details ";
                LOG.error((Object)"AQ Exception encountered , check log (hermes.log) for more details ", (Throwable)e);
            }
            catch (SQLException e) {
                String msg = "SQL Exception encountered , check log (hermes.log) for more details ";
                LOG.error((Object)"SQL Exception encountered , check log (hermes.log) for more details ", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                String msg = "ClassNotFoundException encountered , check log (hermes.log) for more details ";
                LOG.error((Object)"ClassNotFoundException encountered , check log (hermes.log) for more details ", (Throwable)e);
            }
            finally {
                if (aqQueue != null) {
                    aqQueue.close();
                }
                if (aqSession != null) {
                    aqSession.close();
                }
            }
        }
        if (remList) {
            list.remove(dConfig);
        }
    }
}

