/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views.configuration;

import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IntegerInput;
import com.jrockit.mc.components.ui.settings.LocalizedStringInput;
import com.jrockit.mc.components.ui.settings.UnitInput;
import com.jrockit.mc.greychart.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.TickDensityName;

public class ChartGeneralInput
extends CompositeInput {
    public ChartGeneralInput(String key) {
        super(Messages.CHART_COMPONENT_CONFIGURATION_GENERAL_TITLE, key);
        this.addInputs();
    }

    protected void addInputs() {
        this.addInput((IInput)this.createShowTickMarks());
        this.addInput(this.createTickDensity());
        this.addInput((IInput)this.createShowGridLines());
        this.addInput((IInput)this.createShowAlwaysZero());
        this.addInput((IInput)this.createPaxAxis());
        this.addInput((IInput)this.createShowAxisLegend());
        this.addInput((IInput)this.createAxisName());
        this.addInput((IInput)this.createAxisDescription());
        this.addInput((IInput)this.createUnit());
        this.addInput(this.createAxisMinWidth());
    }

    private IInput createAxisMinWidth() {
        return new IntegerInput("minimumWidth", Messages.COMMON_INPUTS_MINIMUM_WIDTH, Integer.valueOf(0), Integer.valueOf(1000));
    }

    protected UnitInput createUnit() {
        return new UnitInput("unit", false);
    }

    protected LocalizedStringInput createAxisDescription() {
        return new LocalizedStringInput("description", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_DESCRIPTION_INPUT_TEXT);
    }

    protected LocalizedStringInput createAxisName() {
        return new LocalizedStringInput("title", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_NAME_INPUT_TEXT);
    }

    protected BooleanInput createShowAxisLegend() {
        return new BooleanInput("titleLegend", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_SHOW_AXIS_LEGEND_INPUT_TEXT);
    }

    protected BooleanInput createPaxAxis() {
        return new BooleanInput("autoPad", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_PAD_AXIS_INPUT_TEXT);
    }

    protected BooleanInput createShowAlwaysZero() {
        return new BooleanInput("alwaysShowZero", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_ALWAYS_INCLUDE_ZERO_INPUT_TEXT);
    }

    protected BooleanInput createShowGridLines() {
        return new BooleanInput("showGridLines", Messages.CHART_COMPONENT_CONFIGURATION_AXIS_SHOW_GRID_LINES_INPUT_TEXT);
    }

    protected BooleanInput createShowTickMarks() {
        return new BooleanInput("showTickMarks", Messages.CHART_COMPONENT_CONFIGURATION_AXIS_SHOW_TICK_MARKS_INPUT_TEXT);
    }

    protected IInput createTickDensity() {
        return new ComboInput("tickDensity", Messages.ChartGeneralInput_CHART_COMPONENT_CONFIGURATION_TICK_DENSITY_TEXT, TickDensityName.createNameKeyMap());
    }
}

