/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.tab;

import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.tab.AdjustingVScrolledComposite;
import com.jrockit.mc.console.ui.notification.tab.Messages;
import com.jrockit.mc.console.ui.notification.tab.TriggerSectionPart;
import com.jrockit.mc.console.ui.notification.widget.ActionChooser;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IDiagnosticCommandService;
import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.triggers.ITriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.actions.internal.TriggerActionDiagnosticCommand;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.rjmx.ui.operations.InvocatorBuilderForm;
import com.jrockit.mc.ui.sections.MCSectionPart;
import com.jrockit.mc.ui.uibuilder.FormToolkitBuilder;
import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TriggerActionSectionPart
extends MCSectionPart
implements IPartSelectionListener {
    private final TriggerRule m_notificationRule;
    private final NotificationRegistry m_notificationModel;
    private ActionChooser m_actionChooser;
    private final ActionChooser.ComponentFactory componentFactory = new ActionChooser.ComponentFactory(){

        @Override
        public Composite createComponent(Composite parent, ITriggerAction action) {
            if (action instanceof TriggerActionDiagnosticCommand) {
                try {
                    IDiagnosticCommandService diagCommandService = (IDiagnosticCommandService)TriggerActionSectionPart.this.getConnectionHandle().getServiceOrDummy(IDiagnosticCommandService.class);
                    TriggerActionDiagnosticCommand diagnosticCommandAction = (TriggerActionDiagnosticCommand)action;
                    final Field f = (Field)diagnosticCommandAction.getSetting("command");
                    IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)NotificationPlugin.getDefault().getMCDialogSettings(), (String)"trigger_action_diagnostic_builder");
                    SashForm sash = new SashForm(parent, 256);
                    InvocatorBuilderForm invocatorForm = new InvocatorBuilderForm(sash, TriggerActionSectionPart.this.getManagedForm().getToolkit(), false, true, settings, new InvocatorBuilderForm.InvocatorUpdateListener(){

                        public void onInvocatorUpdated(IOperation operation, Callable<?> invocator) {
                            f.setValue(invocator == null ? "" : invocator.toString());
                        }
                    });
                    invocatorForm.setOperations(diagCommandService.getOperations());
                    return sash;
                }
                catch (Exception e) {
                    NotificationPlugin.getDefault().getLogger().log(Level.FINE, "Could not create diagnostic command ui for trigger action", e);
                }
            }
            return null;
        }
    };

    public TriggerActionSectionPart(Composite parent, FormToolkit toolkit, NotificationRegistry notifcationModel, TriggerRule notifcationRule) {
        super(parent, toolkit, 4096, "");
        this.m_notificationRule = notifcationRule;
        this.m_notificationModel = notifcationModel;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.getSection().setText(Messages.TriggerActionSectionPart_SECTION_TEXT);
        this.getSection().setDescription(Messages.TriggerActionSectionPart_SECTION_DESCRIPTION);
        Composite client = this.createClient(this.getSection(), this.getFormToolkit());
        this.getSection().setClient((Control)client);
    }

    private Composite createClient(Section section, FormToolkit toolkit) {
        AdjustingVScrolledComposite scrolled = new AdjustingVScrolledComposite((Composite)section);
        Composite client = toolkit.createComposite((Composite)scrolled);
        scrolled.setContent((Control)client);
        client.setLayout((Layout)new GridLayout());
        FormToolkitBuilder ftb = new FormToolkitBuilder(toolkit, client);
        this.m_actionChooser = new ActionChooser((IUIBuilder)ftb, this.m_notificationRule, this.getConnectionHandle(), this.m_notificationModel, client, true, true, true, this.componentFactory);
        this.m_actionChooser.createAndAddActionSelectionChangedListener(new Runnable(){

            @Override
            public void run() {
                TriggerActionSectionPart.this.getManagedForm().fireSelectionChanged((IFormPart)TriggerActionSectionPart.this, (ISelection)new StructuredSelection((Object)TriggerActionSectionPart.this.m_notificationRule));
            }
        });
        toolkit.paintBordersFor(client);
        return scrolled;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection s;
        Object o;
        if (part instanceof TriggerSectionPart && (o = (s = (IStructuredSelection)selection).getFirstElement()) instanceof TriggerRule) {
            TriggerRule rule = (TriggerRule)o;
            ITriggerAction action = rule.getAction();
            this.m_actionChooser.select(action);
        }
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getInput();
    }
}

