/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.AbstractUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.IIntervalUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;

public final class SimpleUpdatePolicy
extends AbstractUpdatePolicy
implements IIntervalUpdatePolicy {
    private static final SimpleUpdatePolicy DEFAULT_POLICY = new SimpleUpdatePolicy(UpdatePolicyToolkit.getDefaultUpdateInterval());
    private final int updateTime;

    private SimpleUpdatePolicy(int updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    protected long getFollowingUpdate(long lastUpdate) {
        int updateTime = this.getIntervalTime();
        return lastUpdate - lastUpdate % (long)updateTime + (long)updateTime;
    }

    @Override
    public int getIntervalTime() {
        return this.updateTime;
    }

    @Override
    protected long getFirstUpdate(long now) {
        return now;
    }

    public static IUpdatePolicy newPolicy(int updateTime) {
        if (SimpleUpdatePolicy.DEFAULT_POLICY.updateTime == updateTime) {
            return DEFAULT_POLICY;
        }
        if (updateTime == -1) {
            return DEFAULT_POLICY;
        }
        return new SimpleUpdatePolicy(updateTime);
    }
}

