/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.ui.UIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextControl {
    private ControlDecoration m_controlDecoration;
    private final Text m_text;

    public TextControl(Composite parent, int style) {
        this.m_text = this.createText(parent, style);
    }

    public TextControl(Composite parent, int style, FormToolkit toolkit) {
        this.m_text = this.createText(parent, style, toolkit);
    }

    private Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        this.createControlDecoration(text);
        text.setText("");
        return text;
    }

    private Text createText(Composite parent, int style, FormToolkit toolkit) {
        Text text = toolkit.createText(parent, "", style);
        this.createControlDecoration(text);
        return text;
    }

    private void createControlDecoration(Text text) {
        this.m_controlDecoration = new ControlDecoration((Control)text, 131072);
        this.m_controlDecoration.setImage(UIPlugin.getDefault().getImage("error_obj.gif"));
        this.m_controlDecoration.hide();
    }

    protected final void setErrorDecoration(IStatus status) {
        this.m_controlDecoration.setImage(UIPlugin.getDefault().getImage("error_obj.gif"));
        this.m_controlDecoration.setDescriptionText(status.getMessage());
        this.m_controlDecoration.show();
    }

    protected final void setWarningDecoration(IStatus status) {
        this.m_controlDecoration.setImage(UIPlugin.getDefault().getImage("alert_obj.png"));
        this.m_controlDecoration.setDescriptionText(status.getMessage());
        this.m_controlDecoration.show();
    }

    protected final void setOkDecoration(IStatus status) {
        this.m_controlDecoration.setDescriptionText(null);
        this.m_controlDecoration.hide();
    }

    protected final void updateControlDecoration(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                this.setInfoDecoration(status);
                break;
            }
            case 0: {
                this.setOkDecoration(status);
                break;
            }
            case 2: {
                this.setWarningDecoration(status);
                break;
            }
            case 4: {
                this.setErrorDecoration(status);
                break;
            }
            default: {
                throw new RuntimeException("Unknown status severity " + status.getSeverity());
            }
        }
    }

    protected final void setInfoDecoration(IStatus status) {
        this.setOkDecoration(status);
    }

    public void setText(String text) {
        this.m_text.setText(text);
    }

    public Text getControl() {
        return this.m_text;
    }
}

