/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.contributions;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.contributions.SettingsFileToolkit;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContributionFactory;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContributionMerger;
import com.jrockit.mc.ui.fields.FilterMatcher;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public final class UserInterfaceContributionRepository {
    private final Map<String, UserInterfaceContribution> m_containerCache = new LinkedHashMap<String, UserInterfaceContribution>();

    public Collection<UserInterfaceContribution> getContributions() {
        return this.m_containerCache.values();
    }

    public UserInterfaceContribution findContribution(String id) throws IOException {
        UserInterfaceContribution contribution = this.m_containerCache.get(id);
        if (contribution == null) {
            contribution = UserInterfaceContributionFactory.createFromUserSettings(id);
            contribution.getContributionDescriptor().setContainerIdentifier(id);
            for (UserInterfaceContribution c : UserInterfaceContributionFactory.createFromExtensions()) {
                if (!FilterMatcher.getInstance().match(id, c.getContainerIdentifier())) continue;
                UserInterfaceContributionMerger.merge(c, contribution);
            }
            this.m_containerCache.put(id, contribution);
        }
        return contribution;
    }

    public void clearUserSettings(String id) {
        try {
            SettingsFileToolkit.clearContrubition(id);
            this.m_containerCache.remove(id);
            this.findContribution(id);
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to remove setting files.", e);
        }
    }

    public void persist() {
        for (UserInterfaceContribution uic : this.m_containerCache.values()) {
            try {
                SettingsFileToolkit.persistContribution(uic);
            }
            catch (IOException ex) {
                ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error saving user settings for " + uic.getContainerIdentifier(), ex);
            }
        }
    }
}

