/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import org.netbeans.lib.profiler.global.CommonConstants;

public final class FilterSortSupport
implements CommonConstants {
    public static final String FILTERED_OUT_LBL;

    public static boolean passesFilter(Configuration configuration, String string) {
        return FilterSortSupport.passesFilter(configuration.getFilterString(), configuration.getFilterType(), string);
    }

    public static boolean passesFilter(String string, int n, String string2) {
        switch (n) {
            case 0: {
                return true;
            }
            case 20: {
                return string2.toLowerCase().contains(string);
            }
            case 25: {
                return !string2.toLowerCase().contains(string);
            }
            case 50: {
                try {
                    return string2.matches(string);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
        }
        return false;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.Bundle");
        FILTERED_OUT_LBL = resourceBundle.getString("FilteringSupport_FilteredOutLbl");
    }

    public static final class Configuration {
        private int sortBy;
        private boolean sortOrder;
        private String filterString = "";
        private int filterType = 20;

        public int getSortBy() {
            return this.sortBy;
        }

        public boolean getSortOrder() {
            return this.sortOrder;
        }

        public String getFilterString() {
            return this.filterString;
        }

        public int getFilterType() {
            return this.filterType;
        }

        public void setSortInfo(int n, boolean bl) {
            this.sortBy = n;
            this.sortOrder = bl;
        }

        public void setFilterInfo(String string, int n) {
            this.filterString = string;
            this.filterType = n;
        }
    }
}

