/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRDebug;
import oracle.jvm.hotspot.jfr.JFRStackFrame;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class StackTrace
extends VMObject {
    private static Field idField;
    private static Field reachedRootField;
    private static CIntegerField numOfFramesField;
    private static AddressField nextField;
    private static AddressField framesField;

    public StackTrace(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrStackTraceRepository::StackTrace");
        idField = type.getField("_id");
        reachedRootField = type.getField("_reached_root");
        numOfFramesField = type.getCIntegerField("_nr_of_frames");
        nextField = type.getAddressField("_next");
        framesField = type.getAddressField("_frames");
    }

    public long id() {
        return idField.getJLong(this.addr);
    }

    public boolean reachedRoot() {
        return reachedRootField.getJBoolean(this.addr);
    }

    public int numOfFrames() {
        return (int)numOfFramesField.getValue(this.addr);
    }

    public StackTrace next() {
        return (StackTrace)VMObjectFactory.newObject(StackTrace.class, nextField.getValue(this.addr));
    }

    public Address frames() {
        return framesField.getValue(this.addr);
    }

    public void write(JFRStreamWriter writer) {
        writer.write(this.id());
        writer.write(!this.reachedRoot());
        int num_of_frames = this.numOfFrames();
        writer.write(num_of_frames);
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("StackTrace.write(): Number of frames = " + num_of_frames);
        }
        int FRAME_SIZE = 17;
        for (int i = 0; i < num_of_frames; ++i) {
            Address frameAddr = this.frames().addOffsetTo((long)i * VM.getVM().alignUp(FRAME_SIZE, VM.getVM().getBytesPerWord()));
            if (JFRDebug.SA_JFR_DEBUG) {
                System.out.println("StackTrace.write(): Frame pointer = " + frameAddr);
            }
            JFRStackFrame frame = (JFRStackFrame)VMObjectFactory.newObject(JFRStackFrame.class, frameAddr);
            frame.write(writer);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                StackTrace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

