/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapFactory;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.heapwalk.ui.HeapWalkerUI;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class HeapWalker {
    private File heapDumpFile;
    private HeapFragmentWalker mainHeapWalker;
    private HeapWalkerUI heapWalkerUI;
    private Lookup.Provider heapDumpProject;
    private String heapWalkerName = Bundle.ClassesListController_HeapWalkerDefaultName();

    public HeapWalker(Heap heap) {
        this.createMainFragment(heap);
    }

    public HeapWalker(File file) throws FileNotFoundException, IOException {
        this(HeapWalker.createHeap(file));
        this.heapDumpFile = file;
        this.heapDumpProject = HeapWalker.computeHeapDumpProject(this.heapDumpFile);
        String string = this.heapDumpFile.getName();
        int n = string.lastIndexOf(46);
        if (n > 0 && n <= string.length() - 2) {
            string = string.substring(0, n);
        }
        this.heapWalkerName = ResultsManager.getDefault().getHeapDumpDisplayName(string);
    }

    public File getHeapDumpFile() {
        return this.heapDumpFile;
    }

    public Lookup.Provider getHeapDumpProject() {
        return this.heapDumpProject;
    }

    public HeapFragmentWalker getMainHeapWalker() {
        return this.mainHeapWalker;
    }

    public String getName() {
        return this.heapWalkerName;
    }

    public void open() {
        HeapWalkerManager.getDefault().openHeapWalker(this);
    }

    public TopComponent getTopComponent() {
        if (this.heapWalkerUI == null) {
            this.heapWalkerUI = new HeapWalkerUI(this);
        }
        return this.heapWalkerUI;
    }

    void createMainFragment(Heap heap) {
        this.mainHeapWalker = new HeapFragmentWalker(heap, this, true);
    }

    void createReachableFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    void createRetainedFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private static Lookup.Provider computeHeapDumpProject(File file) {
        if (file == null) {
            return null;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        return ProjectStorage.getProjectFromSettingsFolder((FileObject)fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Heap createHeap(File file) throws FileNotFoundException, IOException {
        ProgressHandle progressHandle = null;
        try {
            progressHandle = ProgressHandleFactory.createHandle((String)Bundle.ClassesListController_LoadingDumpMsg());
            progressHandle.setInitialDelay(0);
            progressHandle.start(2000);
            HeapWalker.setProgress(progressHandle, 0);
            Heap heap = HeapFactory.createHeap((File)file);
            HeapWalker.setProgress(progressHandle, 1000);
            heap.getSummary();
            Heap heap2 = heap;
            return heap2;
        }
        finally {
            if (progressHandle != null) {
                progressHandle.finish();
            }
        }
    }

    private static void setProgress(final ProgressHandle progressHandle, final int n) {
        final BoundedRangeModel boundedRangeModel = HeapProgress.getProgress();
        boundedRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                progressHandle.progress(boundedRangeModel.getValue() + n);
            }
        });
    }
}

