/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.internal.AbstractNotificationConstraint;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public final class NotificationConstraintDayOfWeek
extends AbstractNotificationConstraint
implements IDescribable {
    private static final String XML_ELEMENT_VALID_WEEKDAYS = "valid_weekdays";
    public static final String NAME = "Day of week";
    public static final String DESCRIPTION = "A constraint that allows notification only if the issue day of the event is one of the allowed days.";
    public static final int MONDAY = 0;
    public static final int TUESDAY = 1;
    public static final int WEDNESDAY = 2;
    public static final int THURSDAY = 3;
    public static final int FRIDAY = 4;
    public static final int SATURDAY = 5;
    public static final int SUNDAY = 6;
    private final boolean[] m_validDays = new boolean[7];
    private final GregorianCalendar m_calendar = new GregorianCalendar();

    public NotificationConstraintDayOfWeek() {
    }

    public NotificationConstraintDayOfWeek(boolean[] validDays) {
        if (validDays.length != this.m_validDays.length) {
            throw new IllegalArgumentException("The bit array must be 7 booleans long!");
        }
        int i = 0;
        while (i < this.m_validDays.length) {
            this.m_validDays[i] = validDays[i];
            ++i;
        }
    }

    public void setValidDay(int day, boolean valid) {
        this.m_validDays[day] = valid;
    }

    public boolean isValidDay(int day) {
        return this.m_validDays[day];
    }

    @Override
    public boolean isValid(TriggerEvent e) {
        this.m_calendar.setTime(e.getCreationTime());
        switch (this.m_calendar.get(7)) {
            case 2: {
                return this.m_validDays[0];
            }
            case 3: {
                return this.m_validDays[1];
            }
            case 4: {
                return this.m_validDays[2];
            }
            case 5: {
                return this.m_validDays[3];
            }
            case 6: {
                return this.m_validDays[4];
            }
            case 7: {
                return this.m_validDays[5];
            }
            case 1: {
                return this.m_validDays[6];
            }
        }
        throw new IllegalArgumentException("Error in validation routine!");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public String getExtendedInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append(" valid days = [");
        boolean[] blArray = this.m_validDays;
        int n = this.m_validDays.length;
        int n2 = 0;
        while (n2 < n) {
            boolean m_validDay = blArray[n2];
            if (m_validDay) {
                buf.append(" 1");
            } else {
                buf.append(" 0");
            }
            ++n2;
        }
        buf.append(" ]");
        return buf.toString();
    }

    @Override
    public void initializeFromXml(Element node) {
        String validDays = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_VALID_WEEKDAYS, (String)"true, true, true, true, true, true, true");
        this.setValidDays(validDays);
    }

    @Override
    public void exportToXml(Element constraintNode) {
        XmlToolkit.setSetting((Element)constraintNode, (String)XML_ELEMENT_VALID_WEEKDAYS, (String)this.getValidDaysAsString());
    }

    private String getValidDaysAsString() {
        StringBuilder builder = new StringBuilder();
        boolean[] blArray = this.m_validDays;
        int n = this.m_validDays.length;
        int n2 = 0;
        while (n2 < n) {
            boolean m_validDay = blArray[n2];
            if (m_validDay) {
                builder.append("true,");
            } else {
                builder.append("false,");
            }
            ++n2;
        }
        String weekString = builder.toString();
        return weekString.substring(0, weekString.lastIndexOf(44));
    }

    private void setValidDays(String weekDays) {
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(weekDays, ",");
        while (tokenizer.hasMoreTokens() && index < 7) {
            this.setValidDay(index, Boolean.valueOf(tokenizer.nextToken().trim()));
            ++index;
        }
    }
}

