/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

public final class AttributeSerializationToolkit {
    public static final int DOUBLE_SIZE = 8;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;

    private AttributeSerializationToolkit() {
    }

    public static int getByteSize(Class<?> targetClass) {
        if (targetClass == Long.class || targetClass == Double.class) {
            return 8;
        }
        throw new IllegalArgumentException("The target class " + targetClass.getName() + " is not supported by the persistance framework!");
    }

    public static Number deserializeFromString(String value, Class<?> type) {
        if (value == null) {
            return null;
        }
        assert (Number.class.isAssignableFrom(type));
        if (type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE) {
            return Double.parseDouble(value);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

