/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration;

import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;

public abstract class PathElement {
    public static final char PATH_SLASH_SEPARATOR = '/';
    private final String m_name;
    private final String humanName;
    private final PropertyContainer m_parent;
    private PathElementKind kind;
    private transient String cachedPath;

    protected PathElement(PropertyContainer parent, String name, String humanName, PathElementKind kind) {
        this.m_name = name;
        this.humanName = humanName;
        this.m_parent = parent;
        this.kind = kind;
    }

    public final PropertyContainer getParent() {
        return this.m_parent;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getHumanReadableName() {
        return this.humanName;
    }

    protected final void setKind(PathElementKind kind) {
        this.kind = kind;
    }

    protected boolean addKind(PathElementKind kind) {
        PathElementKind newKind = this.kind.add(kind);
        if (newKind != this.kind) {
            this.kind = newKind;
            this.m_parent.addKind(kind);
            return true;
        }
        return false;
    }

    public PathElementKind getKind() {
        return this.kind;
    }

    public final String getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = this.getParent() != null && this.getParent().getName() != null ? String.valueOf(this.getParent().getPath()) + '/' + this.getName() : this.getName();
        }
        return this.cachedPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathElement) {
            return this.getPath().equals(((PathElement)obj).getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    static final class PathElementKind
    extends Enum<PathElementKind> {
        public static final /* enum */ PathElementKind UNKNOWN = new PathElementKind(0);
        public static final /* enum */ PathElementKind IN_CONFIGURATION = new PathElementKind(1);
        public static final /* enum */ PathElementKind IN_SERVER = new PathElementKind(2);
        public static final /* enum */ PathElementKind IN_BOTH = new PathElementKind(3);
        private static final /* synthetic */ PathElementKind[] ENUM$VALUES;

        static {
            ENUM$VALUES = new PathElementKind[]{UNKNOWN, IN_CONFIGURATION, IN_SERVER, IN_BOTH};
        }

        private PathElementKind(int flags) {
            assert (flags == this.ordinal());
        }

        public boolean contains(PathElementKind otherKind) {
            int otherFlags = otherKind.ordinal();
            return (this.ordinal() & otherFlags) == otherFlags;
        }

        public PathElementKind add(PathElementKind otherKind) {
            return PathElementKind.values()[this.ordinal() | otherKind.ordinal()];
        }

        public static PathElementKind[] values() {
            PathElementKind[] pathElementKindArray = ENUM$VALUES;
            int n = pathElementKindArray.length;
            PathElementKind[] pathElementKindArray2 = new PathElementKind[n];
            System.arraycopy(ENUM$VALUES, 0, pathElementKindArray2, 0, n);
            return pathElementKindArray2;
        }

        public static PathElementKind valueOf(String string) {
            return Enum.valueOf(PathElementKind.class, string);
        }
    }
}

