/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.ui.UIPlugin;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.JComponent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SwingComponentCanvas
extends Canvas
implements PaintListener {
    protected JComponent m_jcomponent;
    private ImageData imageDataSWT;
    private BufferedImage imageAWT;
    private Graphics2D graphicsAWT;

    public final JComponent getJComponent() {
        return this.m_jcomponent;
    }

    public SwingComponentCanvas(Composite parent, JComponent jComponent, int style) {
        super(parent, style);
        this.m_jcomponent = jComponent;
        this.init();
    }

    public final void init() {
        this.addPaintListener(this);
    }

    public boolean useAntiAliasing() {
        return UIPlugin.getDefault().getPreferenceStore().getBoolean("graphics.antialiasing");
    }

    public void paintControl(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        this.m_jcomponent.setSize(rect.width, rect.height);
        this.m_jcomponent.doLayout();
        if (this.imageDataSWT == null || this.imageDataSWT.width != rect.width || this.imageDataSWT.height != rect.height) {
            this.imageAWT = new BufferedImage(rect.width, rect.height, 5);
            PaletteData vpPalette = new PaletteData(255, 65280, 0xFF0000);
            int scanlinePad = rect.width * 3;
            byte[] byteData = ((DataBufferByte)this.imageAWT.getRaster().getDataBuffer()).getData();
            this.graphicsAWT = this.imageAWT.createGraphics();
            if (this.useAntiAliasing()) {
                this.graphicsAWT.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                this.graphicsAWT.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.imageDataSWT = new ImageData(rect.width, rect.height, 24, vpPalette, scanlinePad, byteData);
        }
        this.paintRecursive(this.m_jcomponent, this.graphicsAWT);
        try {
            Image img = new Image((Device)e.display, this.imageDataSWT);
            e.gc.drawImage(img, rect.x, rect.y);
            img.dispose();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void paintRecursive(Component j, Graphics2D g) {
        Point translate = j.getLocation();
        g.translate(translate.x, translate.y);
        j.paint(g);
        g.translate(-translate.x, -translate.y);
        if (j instanceof Container) {
            Container c = (Container)j;
            int count = c.getComponentCount();
            int i = count - 1;
            while (i >= 0) {
                this.paintRecursive(c.getComponent(i), g);
                --i;
            }
        }
    }
}

