/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfiguration;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import java.util.HashMap;
import java.util.Iterator;

public class VisibilityVisitor
implements IVisitor,
IEventFilter {
    private final HashMap<Object, Boolean> m_lookup = new HashMap(501);
    private boolean m_showOnlyWorkSet;
    private final ChartConfiguration m_chartConfiguration;

    public VisibilityVisitor(ChartConfiguration chartConfiguration) {
        this.m_chartConfiguration = chartConfiguration;
    }

    @Override
    public boolean visit(UIThreadGroup uiThreadGroup) {
        Iterator<UIThread> it = uiThreadGroup.getThreads().iterator();
        while (it.hasNext()) {
            if (!this.visit(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visit(UIThread uiTHread) {
        Iterator<UITrack> it = uiTHread.getTracks().iterator();
        while (it.hasNext()) {
            if (!this.visit(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visit(UITrack uiLevellInstance) {
        Boolean b = this.getLookupVisibility(uiLevellInstance);
        if (b == null) {
            boolean v = this.calcLevelVisibility(uiLevellInstance);
            this.setLookupVisibilty(uiLevellInstance, v);
            return v;
        }
        return b;
    }

    @Override
    public boolean visit(UIGarbageCollector uiGarabage) {
        return this.m_chartConfiguration.isGCBackdropVisible();
    }

    @Override
    public boolean visit(IEvent event) {
        IEventType type = event.getEventType();
        if (type != null && EventToolkit.isVisible(type)) {
            return !this.m_showOnlyWorkSet || EventToolkit.isPartOfOperativeSet(event);
        }
        return false;
    }

    public Boolean getLookupVisibility(Object object) {
        return this.m_lookup.get(object);
    }

    private void setLookupVisibilty(Object o, boolean b) {
        this.m_lookup.put(o, b);
    }

    private boolean calcLevelVisibility(UITrack uiTrack) {
        if (this.m_showOnlyWorkSet) {
            for (IEvent event : uiTrack) {
                if (!EventToolkit.isVisible(event.getEventType()) || !EventToolkit.isPartOfOperativeSet(event)) continue;
                return true;
            }
        } else {
            Iterator<IEvent> eventIt = uiTrack.iterator();
            while (eventIt.hasNext()) {
                if (!EventToolkit.isVisible(eventIt.next().getEventType())) continue;
                return true;
            }
        }
        return false;
    }

    public void setShowOnlyWorkSet(boolean showOnlyWorkSet) {
        this.m_showOnlyWorkSet = showOnlyWorkSet;
    }

    public boolean getShowOnlyWorkSet() {
        return this.m_showOnlyWorkSet;
    }

    public void clearCache() {
        this.m_lookup.clear();
    }

    public final boolean accept(IEvent event) {
        return this.visit(event);
    }

    public boolean isShowOnlyWorkSet() {
        return this.m_showOnlyWorkSet;
    }
}

