/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.flightrecorder.util.EqualsToolkit;

public final class FrameEqualityChecker {
    private final boolean distinguishByFrameType;
    private final boolean distinguishByLineNumber;
    private final boolean distinguishByBci;

    public FrameEqualityChecker(boolean distinguishByFrameType, boolean distinguishByLineNumber, boolean distinguishByBci) {
        this.distinguishByFrameType = distinguishByFrameType;
        this.distinguishByLineNumber = distinguishByLineNumber;
        this.distinguishByBci = distinguishByBci;
    }

    boolean isEqual(IMCFrame frameA, IMCFrame frameB) {
        if (frameA != null && frameB != null) {
            return this.checkBci(frameA, frameB) && this.checkFrameType(frameA, frameB) && this.checkLineNumber(frameA, frameB) && this.hasSameMethod(frameA, frameB);
        }
        return frameA == frameB;
    }

    private boolean hasSameMethod(IMCFrame frameA, IMCFrame frameB) {
        IMCMethod methodA = frameA.getMethod();
        IMCMethod methodB = frameB.getMethod();
        if (methodA != null && methodB != null) {
            return EqualsToolkit.nullSafeEquals((Object)methodA.getMethodName(), (Object)methodB.getMethodName()) && EqualsToolkit.nullSafeEquals((Object)methodA.getFormalDescriptor(), (Object)methodB.getFormalDescriptor()) && EqualsToolkit.nullSafeEquals((Object)methodA.getPackageName(), (Object)methodB.getPackageName()) && EqualsToolkit.nullSafeEquals((Object)methodA.getClassName(), (Object)methodB.getClassName());
        }
        return methodA == methodB;
    }

    private boolean checkFrameType(IMCFrame frameA, IMCFrame frameB) {
        return !this.isDistinguishByFrameType() || EqualsToolkit.nullSafeEquals((Object)frameA.getType(), (Object)frameB.getType());
    }

    private boolean checkLineNumber(IMCFrame frameA, IMCFrame frameB) {
        return !this.distinguishByLineNumber || EqualsToolkit.nullSafeEquals((Object)frameA.getFrameLineNumber(), (Object)frameB.getFrameLineNumber());
    }

    private boolean checkBci(IMCFrame frameA, IMCFrame frameB) {
        return !this.distinguishByBci || EqualsToolkit.nullSafeEquals((Object)frameA.getBCI(), (Object)frameB.getBCI());
    }

    public boolean isDistinguishByFrameType() {
        return this.distinguishByFrameType;
    }

    public boolean isDistinguishByBci() {
        return this.distinguishByBci;
    }

    public boolean isDistinguishByLineNumber() {
        return this.distinguishByLineNumber;
    }
}

