/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration;

import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.Property;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContentBuilder;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.IEventTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class PropertyContainer
extends PathElement {
    public PropertyContainer(PropertyContainer parent, String name, String humanName, PathElement.PathElementKind kind) {
        super(parent, name, humanName, kind);
    }

    @Override
    public PathElement.PathElementKind getKind() {
        PathElement.PathElementKind currentKind = super.getKind();
        if (currentKind != PathElement.PathElementKind.UNKNOWN) {
            return currentKind;
        }
        PathElement.PathElementKind kind = this.getChildrenKind();
        this.setKind(kind);
        return kind;
    }

    private PathElement.PathElementKind getChildrenKind() {
        PathElement.PathElementKind childrenKind = PathElement.PathElementKind.IN_SERVER;
        for (PathElement pathElement : this.getChildren()) {
            PathElement.PathElementKind childKind = pathElement.getKind();
            if (childKind == PathElement.PathElementKind.IN_CONFIGURATION) {
                return childKind;
            }
            if (childrenKind == childKind) continue;
            childrenKind = PathElement.PathElementKind.IN_BOTH;
        }
        return childrenKind;
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public abstract List<? extends PathElement> getChildren();

    static class EventNode
    extends PropertyContainer {
        private final EventTypeID eventTypeID;
        private final List<Property> m_options = new ArrayList<Property>();

        public EventNode(PropertyContainer parent, String name, String humanName, EventTypeID eventTypeID, PathElement.PathElementKind kind) {
            super(parent, name, humanName, kind);
            this.eventTypeID = eventTypeID;
        }

        public List<Property> getChildren() {
            return this.m_options;
        }

        public void addToOption(String optionKey, PathElement.PathElementKind kind, String value) {
            Property option2;
            for (Property option2 : this.m_options) {
                if (!optionKey.equals(option2.getName())) continue;
                option2.addKind(kind);
                return;
            }
            option2 = new Property(this, optionKey, PropertyContentBuilder.getLocalizedOptionName(optionKey), kind, value);
            this.m_options.add(option2);
        }

        public EventTypeID getEventTypeID() {
            return this.eventTypeID;
        }
    }

    static class FolderNode
    extends PropertyContainer {
        private final List<PropertyContainer> m_containers = new ArrayList<PropertyContainer>();

        public FolderNode(PropertyContainer parent, String name, String humanName, PathElement.PathElementKind kind) {
            super(parent, name, humanName, kind);
        }

        @Override
        public List<? extends PathElement> getChildren() {
            return this.m_containers;
        }

        public FolderNode createOrGetFolder(String name, PathElement.PathElementKind kind) {
            String fullPath = this.getName() != null ? String.valueOf(this.getPath()) + '/' + name : name;
            String humanName = EventAppearance.getHumanSegmentName((String)fullPath);
            for (PropertyContainer container : this.m_containers) {
                FolderNode folder;
                if (!(container instanceof FolderNode) || !(folder = (FolderNode)container).getHumanReadableName().equals(humanName)) continue;
                folder.addKind(kind);
                return folder;
            }
            FolderNode folder = new FolderNode(this, name, humanName, kind);
            this.add(folder);
            return folder;
        }

        public EventNode createOrGetEvent(EventTypeID eventTypeID, PathElement.PathElementKind kind, Map<EventTypeID, IEventTypeInfo> eventTypeInfos) {
            for (PropertyContainer container : this.m_containers) {
                if (!(container instanceof EventNode) || !eventTypeID.equals((Object)((EventNode)container).eventTypeID)) continue;
                container.addKind(kind);
                return (EventNode)container;
            }
            String eventPath = eventTypeID.getEventPath();
            int separator = eventPath.lastIndexOf(47);
            String name = separator >= 0 ? eventPath.substring(separator + 1) : eventPath;
            IEventTypeInfo typeInfo = eventTypeInfos.get(eventTypeID);
            String humanName = typeInfo != null ? typeInfo.getHumanReadableName() : EventAppearance.humanifyName((String)name);
            EventNode p = new EventNode(this, name, humanName, eventTypeID, kind);
            this.add(p);
            return p;
        }

        private void add(PropertyContainer container) {
            this.m_containers.add(container);
        }
    }
}

