/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.util.logging.LogRecord;

final class ProjectOp {
    private final String name;
    private final String type;
    private final boolean startup;
    private final int number;

    private ProjectOp(String string, String string2, int n, boolean bl) {
        this.name = ProjectOp.fixName(string, true);
        this.type = ProjectOp.fixName(string2, false);
        this.number = n;
        this.startup = bl;
    }

    private static String fixName(String string, boolean bl) {
        if (bl) {
            if (string.indexOf("Maven") >= 0) {
                return "Maven";
            }
            if (string.endsWith("Project")) {
                return string.substring(0, string.length() - 7);
            }
        }
        return string;
    }

    public String getProjectDisplayName() {
        return this.name;
    }

    public String getProjectType() {
        return this.type;
    }

    public int getDelta() {
        return this.number;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public static ProjectOp valueOf(LogRecord logRecord) {
        if ("UI_CLOSED_PROJECTS".equals(logRecord.getMessage())) {
            int n;
            String string = ProjectOp.getStringParam(logRecord, 0, "unknown");
            String string2 = ProjectOp.getStringParam(logRecord, 1, "unknown");
            try {
                n = Integer.parseInt(ProjectOp.getStringParam(logRecord, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(string2, string, -n, false);
        }
        if ("UI_OPEN_PROJECTS".equals(logRecord.getMessage())) {
            int n;
            String string = ProjectOp.getStringParam(logRecord, 0, "unknown");
            String string3 = ProjectOp.getStringParam(logRecord, 1, "unknown");
            try {
                n = Integer.parseInt(ProjectOp.getStringParam(logRecord, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(string3, string, n, false);
        }
        if ("UI_INIT_PROJECTS".equals(logRecord.getMessage())) {
            int n;
            String string = ProjectOp.getStringParam(logRecord, 0, "unknown");
            String string4 = ProjectOp.getStringParam(logRecord, 1, "unknown");
            try {
                n = Integer.parseInt(ProjectOp.getStringParam(logRecord, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(string4, string, n, true);
        }
        return null;
    }

    private static String getStringParam(LogRecord logRecord, int n, String string) {
        if (logRecord == null) {
            return string;
        }
        Object[] objectArray = logRecord.getParameters();
        if (objectArray == null || objectArray.length <= n) {
            return string;
        }
        if (objectArray[n] instanceof String) {
            return (String)objectArray[n];
        }
        return string;
    }
}

