/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.config.Config;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.URLUtil;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import sun.misc.Resource;

public abstract class DeployURLClassLoader
extends URLClassLoader {
    protected DeployURLClassLoader(URL[] uRLArray) {
        super(uRLArray);
    }

    protected DeployURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
    }

    public abstract boolean wantsAllPerms(CodeSource var1);

    public abstract AppInfo getAppInfo(URL var1);

    public abstract Preloader getPreloader();

    public abstract DeploymentRuleSet getDeploymentRuleSet(URL var1);

    public abstract Resource getResourceAsResource(String var1) throws MalformedURLException, FileNotFoundException;

    protected boolean getResourcePermission(CodeSource codeSource, boolean bl, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader, boolean bl2) {
        if (bl && codeSource.getCertificates() != null) {
            try {
                long l = TrustDecider.isAllPermissionGranted(codeSource, appInfo, deploymentRuleSet, preloader);
                if (l != 0L) {
                    return true;
                }
                Trace.println("User declined to load signed content from: " + codeSource.getLocation(), TraceLevel.SECURITY);
                return false;
            }
            catch (Exception exception) {
                BadCertificateDialog.showDialog(codeSource, appInfo, exception);
                return false;
            }
        }
        try {
            SandboxSecurity.isPermissionGranted(codeSource, appInfo, deploymentRuleSet, preloader, bl2);
            return true;
        }
        catch (Exception exception) {
            Trace.println("User declined to load unsigned content from: " + codeSource.getLocation(), TraceLevel.SECURITY);
            return false;
        }
    }

    public InputStream getResourceAsStream(String string) {
        Object var2_2 = null;
        try {
            CodeSource codeSource;
            String string2;
            Resource resource = this.getResourceAsResource(string);
            if (resource == null) {
                return super.getResourceAsStream(string);
            }
            boolean bl = true;
            URL uRL = resource.getURL();
            String string3 = string2 = uRL != null ? uRL.getProtocol() : null;
            if ("jar".equalsIgnoreCase(string2)) {
                bl = false;
                uRL = URLUtil.getInnerURL(uRL);
            }
            if (this.getResourcePermission(codeSource = Config.isJavaVersionAtLeast16() ? new CodeSource(uRL, resource.getCodeSigners()) : new CodeSource(uRL, resource.getCertificates()), this.wantsAllPerms(codeSource), this.getAppInfo(uRL), this.getDeploymentRuleSet(uRL), this.getPreloader(), bl)) {
                return resource.getInputStream();
            }
        }
        catch (Throwable throwable) {
            return super.getResourceAsStream(string);
        }
        return null;
    }

    protected void checkPackageAccess(String string) {
        SecurityManager securityManager;
        int n = string.lastIndexOf(46);
        if (n != -1 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
    }
}

