/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public final class MaximizeWindowAction
extends AbstractAction
implements Presenter.Popup,
Presenter.Menu {
    private final PropertyChangeListener propListener;
    private Reference<TopComponent> topComponent;
    private JCheckBoxMenuItem menuItem;
    private boolean state = true;

    public MaximizeWindowAction() {
        String string = NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_MaximizeWindowAction");
        this.putValue("Name", string);
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("maximizedMode".equals(string) || "editorAreaState".equals(propertyChangeEvent.getPropertyName()) || "modes".equals(propertyChangeEvent.getPropertyName()) || "activeMode".equals(propertyChangeEvent.getPropertyName())) {
                    MaximizeWindowAction.this.updateState();
                }
                if ("activated".equals(string)) {
                    MaximizeWindowAction.this.updateState();
                }
            }
        };
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        windowManagerImpl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)windowManagerImpl)));
        this.updateState();
    }

    public MaximizeWindowAction(TopComponent topComponent) {
        String string = NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_MaximizeWindowAction");
        this.putValue("Name", string);
        this.topComponent = new WeakReference<TopComponent>(topComponent);
        this.propListener = null;
        this.updateState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.state = !this.state;
        this.getMenuItem().setSelected(this.state);
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent topComponent = this.getTCToWorkWith();
        if (windowManagerImpl.isDocked(topComponent)) {
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            String string = windowManagerImpl.findTopComponentID(topComponent);
            if (modeImpl.getKind() == 2) {
                windowManagerImpl.userToggledTopComponentSlideInMaximize(string);
            } else if (null != modeImpl) {
                ModeImpl modeImpl2 = windowManagerImpl.getCurrentMaximizedMode();
                if (null != modeImpl2) {
                    if (modeImpl2.getKind() == 1 && modeImpl.getKind() == 0) {
                        windowManagerImpl.switchMaximizedMode(modeImpl);
                    } else {
                        windowManagerImpl.switchMaximizedMode(null);
                    }
                } else {
                    windowManagerImpl.switchMaximizedMode(modeImpl);
                }
            } else {
                windowManagerImpl.switchMaximizedMode(null);
            }
        } else {
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            if (modeImpl != null) {
                if (modeImpl.getFrameState() == 0) {
                    modeImpl.setFrameState(6);
                } else {
                    modeImpl.setFrameState(0);
                }
            }
        }
        this.updateState();
    }

    private void updateState() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                MaximizeWindowAction.this.doUpdateState();
            }
        });
    }

    private void doUpdateState() {
        boolean bl;
        TopComponent topComponent;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent = this.getTCToWorkWith());
        if (modeImpl == null || !Switches.isTopComponentMaximizationEnabled() || !Switches.isMaximizationEnabled(topComponent) || !windowManagerImpl.isDocked(topComponent) && !windowManagerImpl.isEditorMode(modeImpl)) {
            this.getMenuPresenter().setSelected(false);
            this.getPopupPresenter().setSelected(false);
            this.setEnabled(false);
            return;
        }
        if (windowManagerImpl.isDocked(topComponent)) {
            bl = windowManagerImpl.getCurrentMaximizedMode() != modeImpl;
        } else {
            boolean bl2 = bl = modeImpl.getFrameState() == 0;
        }
        if (modeImpl != null && modeImpl.getKind() == 2) {
            bl = null != topComponent && !windowManagerImpl.isTopComponentMaximizedWhenSlidedIn(windowManagerImpl.findTopComponentID(topComponent));
        }
        this.state = !bl;
        this.getMenuPresenter().setSelected(this.state);
        this.getPopupPresenter().setSelected(this.state);
        this.setEnabled(modeImpl != null);
    }

    private TopComponent getTCToWorkWith() {
        TopComponent topComponent;
        if (this.topComponent != null && (topComponent = this.topComponent.get()) != null) {
            return topComponent;
        }
        return TopComponent.getRegistry().getActivated();
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("MaximizeWindow", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("MaximizeWindow");
        }
        return super.getValue(string);
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuItem();
    }

    public JMenuItem getMenuPresenter() {
        return this.getMenuItem();
    }

    private JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
            this.menuItem.setState(this.state);
        }
        return this.menuItem;
    }
}

