/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.IPrefix;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.Messages;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class KindOfQuantity<Q extends IQuantity>
extends ContentType<Q> {
    private final Map<String, IUnit<Q>> m_units = new LinkedHashMap<String, IUnit<Q>>();

    String resolveLocalizedName(IPrefix<?> prefix, String atomUnitId, String defaultAtomUnitName) {
        String name = Messages.getString("Unit_" + this.getIdentifier() + '_' + prefix.identifier() + atomUnitId + "_name", null);
        if (name == null && defaultAtomUnitName != null) {
            name = String.valueOf(prefix.localizedName()) + defaultAtomUnitName;
        }
        return "".equals(name) ? null : name;
    }

    String resolveLocalizedSymbol(IPrefix<?> prefix, String atomUnitId, String defaultAtomUnitSymbol) {
        String symbol = Messages.getString("Unit_" + this.getIdentifier() + '_' + prefix.identifier() + atomUnitId + "_symbol", null);
        if (symbol == null) {
            symbol = String.valueOf(prefix.symbol()) + defaultAtomUnitSymbol;
        }
        return symbol;
    }

    public static <T extends IQuantity> String format(Number number, IUnit<T> unit) {
        T quantity = unit.quantity(number);
        return unit.getContentType().getDefaultDisplayUnit().format(quantity);
    }

    KindOfQuantity(String identifier) {
        super(identifier);
    }

    KindOfQuantity(String identifier, String localizedName) {
        super(identifier, localizedName);
    }

    public abstract IUnit<Q> getDefaultUnit();

    protected void addUnit(IUnit<Q> unit) {
        assert (unit.getIdentifier() != null);
        IUnit<Q> existing = this.m_units.put(unit.getIdentifier(), unit);
        assert (existing == null);
    }

    public Collection<? extends IUnit<Q>> getCommonUnits() {
        return this.m_units.values();
    }

    public Collection<? extends IUnit<Q>> getAllUnits() {
        return this.m_units.values();
    }

    public IUnit<Q> getUnit(String id) {
        return this.m_units.get(id);
    }

    public abstract Q parsePersisted(String var1) throws QuantityConversionException;

    public abstract Q parseInteractive(String var1) throws QuantityConversionException;

    public abstract IUnit<Q> getPreferredUnit(Q var1, double var2, double var4);

    public static class ExactFormatter<Q extends IQuantity>
    extends DisplayUnit<Q> {
        protected ExactFormatter(KindOfQuantity<Q> kindOfQuantity) {
            this(kindOfQuantity, "Exact");
        }

        protected ExactFormatter(KindOfQuantity<Q> kindOfQuantity, String name) {
            super(kindOfQuantity, "exact", name);
        }

        @Override
        public String format(Q quantity) {
            if (quantity instanceof LinearQuantity) {
                return ((LinearQuantity)quantity).localizedFormat(false, true);
            }
            return quantity.interactiveFormat();
        }
    }

    public static class VerboseFormatter<Q extends IQuantity>
    extends DisplayUnit<Q> {
        protected VerboseFormatter(KindOfQuantity<Q> kindOfQuantity) {
            this(kindOfQuantity, "Verbose");
        }

        protected VerboseFormatter(KindOfQuantity<Q> kindOfQuantity, String name) {
            super(kindOfQuantity, "verbose", name);
        }

        @Override
        public String format(Q quantity) {
            if (quantity instanceof LinearQuantity) {
                LinearQuantity linQuantity = (LinearQuantity)quantity;
                LinearUnit unit = linQuantity.getUnit();
                if (unit.isCustom()) {
                    return String.valueOf(linQuantity.localizedFormat(false, true)) + " \u2248 " + linQuantity.localizedFormat(false, false);
                }
                return linQuantity.localizedFormat(false, false);
            }
            return quantity.interactiveFormat();
        }
    }
}

