/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.ui.fields.FilterMatcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

class MatchingFilter
extends ViewerFilter {
    private final Set<TypeFolder> matchesParents = new HashSet<TypeFolder>();
    private final Set<Object> matching = new HashSet<Object>();
    private final Set<Object> allow = new HashSet<Object>();
    private final FilterMatcher m_filterMatcher;
    private final Iterable<TypeFolder> folders;

    MatchingFilter(Iterable<TypeFolder> folders) {
        this.folders = folders;
        this.m_filterMatcher = FilterMatcher.getInstance();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.allow.contains(element) || this.matchesParents.contains(element) || this.matching.contains(element);
    }

    void setFilterText(String filterString) {
        this.matchesParents.clear();
        this.matching.clear();
        this.allow.clear();
        if (filterString != null) {
            for (TypeFolder f : this.folders) {
                this.folderMatch(f, false, "*" + filterString.toLowerCase() + "*");
            }
        }
    }

    private boolean folderMatch(TypeFolder folder, boolean matchingParent, String filterString) {
        boolean folderMatches = false;
        if (this.m_filterMatcher.matchCaseUnsensitive(folder.getName(), filterString)) {
            folderMatches = true;
            this.matching.add(folder);
        }
        boolean matchingChild = false;
        for (TypeDescriptor td : folder.getTypeDescriptors()) {
            if (this.m_filterMatcher.matchCaseUnsensitive(td.getName(), filterString)) {
                matchingChild = true;
                this.matching.add(td);
                continue;
            }
            if (!matchingParent) continue;
            this.allow.add(td);
        }
        for (TypeFolder child : folder.getFolders()) {
            boolean bl = matchingChild = this.folderMatch(child, matchingParent || folderMatches, filterString) || matchingChild;
        }
        if (matchingChild || folderMatches) {
            this.matchesParents.add(folder);
            return true;
        }
        if (matchingParent) {
            this.allow.add(folder);
        }
        return false;
    }

    boolean isMatching(Object element) {
        return this.matching.contains(element);
    }

    Collection<TypeFolder> getMatchesParents() {
        return this.matchesParents;
    }
}

