/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.ui.attributes.MRIAttribute;
import com.jrockit.mc.rjmx.ui.attributes.MRIAttributeInspector;
import com.jrockit.mc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.rjmx.ui.internal.SectionPartManager;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DialogSettingsToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class GcTableSectionPart
extends MCClientSectionPart {
    private final IConnectionHandle connectionHandle;
    private final SectionPartManager sectionPartManager;

    public GcTableSectionPart(SectionPartManager sectionPartManager, Composite parent, FormToolkit toolkit, int style, String id, IConnectionHandle ch) {
        super(parent, toolkit, style, id);
        this.sectionPartManager = sectionPartManager;
        this.connectionHandle = ch;
    }

    private IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    private List<ObjectName> findGcNames() {
        ArrayList<ObjectName> gcNames = new ArrayList<ObjectName>();
        IMBeanHelperService h = (IMBeanHelperService)this.getConnectionHandle().getServiceOrDummy(IMBeanHelperService.class);
        try {
            for (Map.Entry entry : h.getMBeanInfos().entrySet()) {
                ObjectName o = (ObjectName)entry.getKey();
                if (!o.getDomain().equals("java.lang") || !"GarbageCollector".equals(o.getKeyProperty("type"))) continue;
                gcNames.add(o);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return gcNames;
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        CTabFolder tabFolder = new CTabFolder(section, 0);
        formToolkit.adapt((Composite)tabFolder);
        IDialogSettings settings = ConsolePlugin.getDefault().getMCDialogSettings();
        IDialogSettings defaultSettings = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)this.getSectionIdentifier());
        for (ObjectName gcName : this.findGcNames()) {
            String name = gcName.getKeyProperty("name");
            IDialogSettings gcSettings = settings.getSection(String.valueOf(this.getSectionIdentifier()) + name);
            if (gcSettings == null) {
                gcSettings = settings.addNewSection(String.valueOf(this.getSectionIdentifier()) + name);
                DialogSettingsToolkit.copySections((IDialogSettings)defaultSettings, (IDialogSettings)gcSettings);
            }
            MRIAttributeInspector ai = new MRIAttributeInspector(this.sectionPartManager, (Composite)tabFolder, gcSettings, this.getConnectionHandle(), true);
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setControl((Control)ai.getControl());
            tabItem.setText(name);
            ArrayList<ReadOnlyMRIAttribute> l = new ArrayList<ReadOnlyMRIAttribute>();
            l.add(this.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "CollectionTime"), ai));
            l.add(this.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "CollectionCount"), ai));
            l.add(this.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/startTime"), ai));
            l.add(this.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/endTime"), ai));
            l.add(this.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/duration"), ai));
            l.add(this.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/id"), ai));
            l.add(this.createGcAttribute(new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/GcThreadCount"), ai));
            ai.setInput(l);
        }
        tabFolder.setSelection(0);
        return tabFolder;
    }

    private ReadOnlyMRIAttribute createGcAttribute(MRI mri, final MRIAttributeInspector ai) {
        final ReadOnlyMRIAttribute attribute = MRIAttribute.create((IConnectionHandle)this.getConnectionHandle(), (MRI)mri);
        ((ISubscriptionService)this.getConnectionHandle().getServiceOrDummy(ISubscriptionService.class)).addMRIValueListener(mri, new IMRIValueListener(){

            public void valueChanged(final MRIValueEvent event) {
                DisplayToolkit.safeAsyncExec((Widget)GcTableSectionPart.this.getSection(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!ai.getControl().isDisposed()) {
                            attribute.updateValue(event.getValue());
                            ai.getControl().getViewer().update((Object)attribute, null);
                        }
                    }
                });
            }
        });
        return attribute;
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.GcTableSectionPart_GC_TABLE_SECTION_TITLE);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }
}

