/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.ByteUnit;
import com.jrockit.mc.ui.model.fields.Messages;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.NumberFormat;
import java.text.ParseException;

public class ByteField
extends NumberField {
    private static final NumberFormat FRACTION_FORMATTER = NumberFormat.getInstance();
    private static final NumberFormat INTEGER_FORMATTER;

    static {
        FRACTION_FORMATTER.setMinimumFractionDigits(2);
        FRACTION_FORMATTER.setMaximumFractionDigits(2);
        INTEGER_FORMATTER = NumberFormat.getInstance();
        INTEGER_FORMATTER.setMinimumFractionDigits(0);
        INTEGER_FORMATTER.setMaximumFractionDigits(0);
    }

    public ByteField(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (!ByteField.isValid(number)) {
                return super.formatObject(null);
            }
            long bytes = number.longValue();
            long absBytes = Math.abs(bytes);
            if (absBytes < ByteUnit.KB.getFactor()) {
                if (absBytes == 1L) {
                    return String.valueOf(INTEGER_FORMATTER.format(bytes)) + ' ' + this.getSingleUnit();
                }
                return String.valueOf(INTEGER_FORMATTER.format(bytes)) + ' ' + this.getUnit();
            }
            if (absBytes < ByteUnit.MB.getFactor()) {
                return String.valueOf(FRACTION_FORMATTER.format((double)bytes / (double)ByteUnit.KB.getFactor())) + this.getTimeUnit(String.valueOf(' ') + Messages.ByteField_kB);
            }
            if (absBytes < ByteUnit.GB.getFactor()) {
                return String.valueOf(FRACTION_FORMATTER.format((double)bytes / (double)ByteUnit.MB.getFactor())) + this.getTimeUnit(String.valueOf(' ') + Messages.ByteField_MB);
            }
            return String.valueOf(FRACTION_FORMATTER.format((double)bytes / (double)ByteUnit.GB.getFactor())) + this.getTimeUnit(String.valueOf(' ') + Messages.ByteField_GB);
        }
        return super.formatObject(object);
    }

    private String getSingleUnit() {
        return this.getTimeUnit(Messages.ByteField_BYTE);
    }

    @Override
    public String getUnit() {
        return this.getTimeUnit(Messages.ByteField_BYTES);
    }

    @Override
    public String getTooltip(Object object) {
        if (object instanceof Number && ByteField.isValid((Number)object)) {
            return String.valueOf(INTEGER_FORMATTER.format(((Number)object).longValue())) + ' ' + this.getUnit();
        }
        return null;
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Double o = ByteField.parseNumber(tokenizer);
        if (o instanceof Number) {
            ByteUnit bu;
            long value = ((Number)o).longValue();
            if (tokenizer.hasNext() && (bu = ByteUnit.valueOfString(tokenizer.peek().text)) != null) {
                value *= bu.getFactor();
                tokenizer.next();
            }
            return value;
        }
        return null;
    }
}

