/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.handlers;

import com.jrockit.mc.ui.fields.TableSettingsDialog;
import com.jrockit.mc.ui.handlers.FieldToggleHandler;
import com.jrockit.mc.ui.handlers.Messages;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.MethodField;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;

public class FieldMenus {
    private static final int MAX_FIELD_ITEMS = 10;

    private static MenuManager createSortMenu(final Field[] fields) {
        MenuManager sortColumn = new MenuManager(Messages.FieldViewerContributionFactory_SORT_COLUMNS_MENU_TEXT);
        sortColumn.setRemoveAllWhenShown(true);
        sortColumn.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (fields.length > 1) {
                    Field[] fieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final Field field = fieldArray[n2];
                        if (field.isVisible()) {
                            MenuManager fieldMenu = new MenuManager(field.getName());
                            fieldMenu.add((IAction)new Action(Messages.FieldViewerContributionFactory_SORT_ASCENDING_TEXT, 8){

                                public void run() {
                                    field.notifyListeners("SET_SORT_ORDER_ASCENDING");
                                }
                            });
                            fieldMenu.add((IAction)new Action(Messages.FieldViewerContributionFactory_SORT_DESCENDING_TEXT, 8){

                                public void run() {
                                    field.notifyListeners("SET_SORT_ORDER_DESCENDING");
                                }
                            });
                            manager.add((IContributionItem)fieldMenu);
                        }
                        ++n2;
                    }
                }
            }
        });
        return sortColumn;
    }

    private static MenuManager createVisiblityMenu(final Field[] fields) {
        MenuManager viewColumn = new MenuManager(Messages.FieldViewerContributionFactory_VIEW_COLUMNS_MENU_TEXT);
        if (fields.length > 1) {
            int actionCount = Math.min(fields.length, 10);
            final FieldToggleHandler[] actions = new FieldToggleHandler[actionCount];
            int n = 0;
            while (n < actionCount) {
                actions[n] = new FieldToggleHandler(fields[n].getName(), fields[n], "visible", "visibility.change", true);
                viewColumn.add((IAction)actions[n]);
                ++n;
            }
            viewColumn.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    FieldToggleHandler[] fieldToggleHandlerArray = actions;
                    int n = actions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FieldToggleHandler action = fieldToggleHandlerArray[n2];
                        action.updateEnablement();
                        ++n2;
                    }
                }
            });
            viewColumn.add((IAction)new Action(Messages.FieldViewerContributionFactory_CONFIGURE_TEXT){

                public void run() {
                    TableSettingsDialog tsd = new TableSettingsDialog(null, fields, false);
                    if (tsd.open() == 0) {
                        Field[] fieldArray = fields;
                        int n = fields.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Field field = fieldArray[n2];
                            if (field.hasChanged()) {
                                field.notifyListeners("visibility.change");
                                return;
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
        return viewColumn;
    }

    private static MenuManager createMethodField(MethodField field) {
        MenuManager main = new MenuManager(NLS.bind((String)Messages.FieldViewerContributionFactory_SETTINGS_METHOD_FIELD_X_TEXT, (Object)field.getName()));
        MenuManager returnValueMenu = new MenuManager(Messages.FieldViewerContributionFactory_METHOD_RETURN_VALUE_MENU_TEXT);
        returnValueMenu.add((IAction)new FieldToggleHandler(Messages.FieldViewerContributionFactory_METHOD_RETURN_VALUE_VISIBLE_TEXT, field, "return_value_visible", "content.change", false));
        returnValueMenu.add((IAction)new FieldToggleHandler(Messages.FieldViewerContributionFactory_METHOD_RETURN_VALUE_PACKAGE_NAME_VISIBLE_TEXT, field, "return_value_package_visible", "content.change", false));
        main.add((IContributionItem)returnValueMenu);
        MenuManager classMenu = new MenuManager(Messages.FieldViewerContributionFactory_METHOD_CLASS_MENU_TEXT);
        classMenu.add((IAction)new FieldToggleHandler(Messages.FieldViewerContributionFactory_METHOD_CLASS_VISIBLE_TEXT, field, "class_visible", "content.change", true));
        classMenu.add((IAction)new FieldToggleHandler(Messages.FieldViewerContributionFactory_METHOD_CLASS_PACKAGE_NAME_VISIBLE_TEXT, field, "class_package_visible", "content.change", true));
        main.add((IContributionItem)classMenu);
        MenuManager parameterMenu = new MenuManager(Messages.FieldViewerContributionFactory_METHOD_PARAMETERS_MENU_TEXT);
        parameterMenu.add((IAction)new FieldToggleHandler(Messages.FieldViewerContributionFactory_METHOD_PARAMETERS_VISIBLE_TEXT, field, "parameter_visible", "content.change", true));
        parameterMenu.add((IAction)new FieldToggleHandler(Messages.FieldViewerContributionFactory_METHOD_PARAMETERS_PACKAGE_VISIBLE_TEXT, field, "parameter_package_visible", "content.change", false));
        main.add((IContributionItem)parameterMenu);
        return main;
    }

    public static void install(MenuManager menu, Field[] fields) {
        menu.insertAfter("group.top", (IContributionItem)FieldMenus.createVisiblityMenu(fields));
        menu.insertAfter("group.top", (IContributionItem)FieldMenus.createSortMenu(fields));
        boolean added = false;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field instanceof MethodField) {
                if (!added) {
                    menu.add((IContributionItem)new Separator());
                    added = true;
                }
                menu.add((IContributionItem)FieldMenus.createMethodField((MethodField)field));
            }
            ++n2;
        }
        if (added) {
            menu.add((IContributionItem)new Separator());
        }
    }
}

