/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.fields.FieldColumnLabelProvider;
import com.jrockit.mc.ui.fields.IFieldCellLabelProviderFactory;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

public class DelegatingFieldColumnLabelProvider
extends FieldColumnLabelProvider {
    protected final ILabelProvider imageProvider;
    protected final IFontProvider fontProvider;
    protected final IColorProvider colorProvider;

    public DelegatingFieldColumnLabelProvider(Field field, ResourceManager rsrcManager, ILabelProvider imageProvider, IFontProvider fontProvider, IColorProvider colorProvider) {
        super(field, rsrcManager);
        this.imageProvider = imageProvider;
        this.fontProvider = fontProvider;
        this.colorProvider = colorProvider;
    }

    @Override
    public void update(ViewerCell cell) {
        Row row = (Row)cell.getElement();
        Object cellElement = row.getColumn(this.field.INDEX);
        cell.setText(this.field.formatObject(cellElement));
        if (this.field.INDEX == 0) {
            if (this.imageProvider != null) {
                cell.setImage(this.imageProvider.getImage(row.getElement()));
            } else {
                cell.setImage(this.get(this.field.getImage(cellElement)));
            }
        }
        if (this.fontProvider != null) {
            cell.setFont(this.fontProvider.getFont(row.getElement()));
        }
        if (this.colorProvider != null) {
            cell.setForeground(this.colorProvider.getForeground(row.getElement()));
            cell.setBackground(this.colorProvider.getBackground(row.getElement()));
        }
    }

    public static class Factory
    extends LabelProvider
    implements IFieldCellLabelProviderFactory {
        protected final ILabelProvider imageProvider;
        protected final IFontProvider fontProvider;
        protected final IColorProvider colorProvider;

        public Factory(ILabelProvider provider) {
            this(provider, provider instanceof IFontProvider ? (IFontProvider)provider : null, provider instanceof IColorProvider ? (IColorProvider)provider : null);
        }

        public Factory(ILabelProvider imageProvider, IFontProvider fontProvider) {
            this(imageProvider, fontProvider, null);
        }

        public Factory(ILabelProvider imageProvider, IFontProvider fontProvider, IColorProvider colorProvider) {
            this.imageProvider = imageProvider;
            this.fontProvider = fontProvider;
            this.colorProvider = colorProvider;
        }

        @Override
        public CellLabelProvider createCellLabelProvider(Field field, ResourceManager resourceManager) {
            return new DelegatingFieldColumnLabelProvider(field, resourceManager, this.imageProvider, this.fontProvider, this.colorProvider);
        }

        public void dispose() {
            if (this.imageProvider != null) {
                this.imageProvider.dispose();
            }
            super.dispose();
        }
    }
}

