/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart;

import java.awt.Color;
import java.awt.Rectangle;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.FontAndColors;

public abstract class AbstractChartRenderer
implements ChartRenderer {
    public static final float DEFAULT_MINIMUM_FONT_SIZE = 10.0f;
    private Color m_background = FontAndColors.getDefaultBackground();
    private Color m_foreground = FontAndColors.getDefaultForeground();
    private float m_minimumFontSize = 10.0f;
    private int m_fontSize;
    private Rectangle m_renderedBounds;

    @Override
    public Rectangle getRenderedBounds() {
        return this.m_renderedBounds;
    }

    public void setRenderedBounds(Rectangle renderedBounds) {
        this.m_renderedBounds = renderedBounds;
    }

    public void clearRenderedBounds() {
        this.m_renderedBounds = new Rectangle();
    }

    @Override
    public int getRenderedWidth() {
        return this.getRenderedBounds().width;
    }

    @Override
    public int getRenderedHeight() {
        return this.getRenderedBounds().height;
    }

    public int getFontSize() {
        return this.m_fontSize;
    }

    public void setFontSize(int fontSize) {
        this.m_fontSize = fontSize;
    }

    public float getMinimumFontSize() {
        return this.m_minimumFontSize;
    }

    public void setMinimumFontSize(float minimumFontSize) {
        this.m_minimumFontSize = minimumFontSize;
    }

    protected float getActualFontSize(float preferredFontSize) {
        if (this.getFontSize() != 0) {
            return Math.max(this.getMinimumFontSize(), (float)this.getFontSize());
        }
        return Math.max(this.getMinimumFontSize(), preferredFontSize);
    }

    @Override
    public Color getBackground() {
        return this.m_background;
    }

    @Override
    public void setBackground(Color color) {
        this.m_background = color;
    }

    @Override
    public Color getForeground() {
        return this.m_foreground;
    }

    @Override
    public void setForeground(Color color) {
        this.m_foreground = color;
    }
}

