/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.scripting.model;

import com.jrockit.mc.commands.CommandsPlugin;
import com.jrockit.mc.rcp.application.scripting.model.Process;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.text.ParseException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public final class OperatingSystem {
    private static final int CALM_DOWN_FROM_ASYNC_COUNT = 3;
    private static final int TIME_STEP = 100;
    private static final int TIME_SLICE = 100;
    private final Process m_process;
    private final Display m_display;

    public OperatingSystem(Display display, Process process) {
        this.m_process = process;
        this.m_display = display;
    }

    public void scheduleProcess() {
        DisplayToolkit.safeTimerExec((Display)this.m_display, (int)100, (Runnable)new Runnable(){

            @Override
            public void run() {
                OperatingSystem.this.tryToExecute();
            }
        });
    }

    void waitForCalmDownAndThenExecute(final int iteration, final Process process) {
        if (!this.m_process.isRunning()) {
            return;
        }
        DisplayToolkit.safeTimerExec((Display)this.m_display, (int)100, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!Job.getJobManager().isIdle()) {
                    OperatingSystem.this.waitForCalmDownAndThenExecute(3, process);
                } else if (iteration == 0) {
                    if (OperatingSystem.this.execute(process)) {
                        if (process.isSingleStep()) {
                            return;
                        }
                        OperatingSystem.this.waitForCalmDownAndThenExecute(3, process);
                    }
                } else {
                    OperatingSystem.this.waitForCalmDownAndThenExecute(iteration - 1, process);
                }
            }
        });
    }

    public boolean execute(Process p) {
        if (p.getProgram().getLineCount() > 0) {
            try {
                CommandsPlugin.getDefault().execute(p.getInstruction().getSource(), p.getStandardOut());
            }
            catch (ParseException e) {
                p.getErrorOut().println(e.getMessage());
                p.stop();
                return false;
            }
            p.nextInstruction();
            if (!p.hasMoreinstuctions()) {
                p.terminate();
            }
            return true;
        }
        return false;
    }

    public Process getProcessInFocus() {
        return this.m_process;
    }

    void tryToExecute() {
        if (this.m_process.isRunning()) {
            IJobManager manager = Job.getJobManager();
            if (manager.isIdle()) {
                this.execute(this.m_process);
                if (this.m_process.isSingleStep()) {
                    return;
                }
            }
            this.scheduleProcess();
        }
    }
}

