/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectionContentModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectionViewModel;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeSorter;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.TreeNodeBuilder;
import com.jrockit.mc.rjmx.ui.internal.TreeNodeFilter;
import com.jrockit.mc.ui.misc.TreeStructureContentProvider;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.ObjectName;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AttributeSelectorComponent
extends Composite {
    private static final int MAX_ATTRIBUTES_SYNC_FILTER = 5000;
    private Text filterText;
    private TreeViewer mbeanTreeViewer;
    private final AttributeSelectionViewModel m_viewModel;
    private AttributeSelectionContentModel m_selectorModel;
    private final ListenerList selectionChangedListeners;

    public AttributeSelectorComponent(Composite parent, int style, AttributeSelectionViewModel viewModel) {
        super(parent, style);
        this.m_viewModel = viewModel;
        this.selectionChangedListeners = new ListenerList();
        this.initComponent();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] objectArray = this.selectionChangedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)listener;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    public MRI[] getSelection() {
        if (this.m_selectorModel == null) {
            return new MRI[0];
        }
        return this.m_selectorModel.getSelectedAttributes();
    }

    /*
     * WARNING - void declaration
     */
    public void setInput(AttributeSelectionContentModel selectorModel) {
        int n;
        int n2;
        MBeanPropertiesOrderer.Property[] propertyArray;
        this.m_selectorModel = selectorModel;
        IMRIMetaDataService mds = selectorModel.getMetaDataService();
        TreeNodeBuilder root = new TreeNodeBuilder();
        int mriCount = 0;
        for (MRI mri : selectorModel.getAvailableAttributes()) {
            void var9_9;
            MBeanPropertiesOrderer.Property[] properties;
            ObjectName bean = mri.getObjectName();
            IMRIMetaData md = mds.getMetaData(mri);
            if (this.m_viewModel.isNumericalOnly() && !MRIMetaDataToolkit.isNumerical((IMRIMetaData)md)) continue;
            TreeNodeBuilder treeNodeBuilder = root.getUniqueChild(bean.getDomain());
            propertyArray = properties = MBeanPropertiesOrderer.getOrderedProperties(bean);
            n2 = properties.length;
            n = 0;
            while (n < n2) {
                void var9_11;
                MBeanPropertiesOrderer.Property p = propertyArray[n];
                TreeNodeBuilder treeNodeBuilder2 = var9_11.get(p.getStringRepresentation());
                if (p instanceof MBeanPropertiesOrderer.PropertyWithMBean || treeNodeBuilder2.getValue() == null) {
                    treeNodeBuilder2.setValue(p);
                }
                ++n;
            }
            propertyArray = AttributeToolkit.getParentMris((MRI)mri);
            n2 = propertyArray.length;
            n = 0;
            while (n < n2) {
                MBeanPropertiesOrderer.Property parentMri = propertyArray[n];
                TreeNodeBuilder treeNodeBuilder3 = var9_9.get(parentMri, mds.getMetaData((MRI)parentMri));
                ++n;
            }
            var9_9.get(mri, md);
            ++mriCount;
        }
        ITreeNode[] tree = root.getChildren(null);
        this.mbeanTreeViewer.setInput((Object)tree);
        ArrayList<ITreeNode> selectList = new ArrayList<ITreeNode>();
        ArrayList<ITreeNode> expandList = new ArrayList<ITreeNode>();
        ArrayList<ITreeNode> search = new ArrayList<ITreeNode>();
        search.addAll(Arrays.asList(tree));
        while (!search.isEmpty()) {
            ITreeNode[] children;
            ITreeNode iTreeNode = (ITreeNode)search.remove(0);
            if (iTreeNode.getUserData() instanceof IMRIMetaData) {
                MRI mri = ((IMRIMetaData)iTreeNode.getUserData()).getMRI();
                propertyArray = selectorModel.getInitialExpandedAttributes();
                n2 = propertyArray.length;
                n = 0;
                while (n < n2) {
                    MBeanPropertiesOrderer.Property e = propertyArray[n];
                    if (mri.equals((Object)e)) {
                        expandList.add(iTreeNode);
                    }
                    ++n;
                }
                propertyArray = selectorModel.getSelectedAttributes();
                n2 = propertyArray.length;
                n = 0;
                while (n < n2) {
                    MBeanPropertiesOrderer.Property s = propertyArray[n];
                    if (mri.equals((Object)s)) {
                        selectList.add(iTreeNode);
                    }
                    ++n;
                }
            }
            if ((children = iTreeNode.getChildren()) == null) continue;
            search.addAll(Arrays.asList(children));
        }
        if (!selectList.isEmpty()) {
            this.mbeanTreeViewer.setSelection((ISelection)new StructuredSelection(selectList), true);
        }
        for (ITreeNode iTreeNode : expandList) {
            this.mbeanTreeViewer.expandToLevel((Object)iTreeNode, 0);
        }
        TreeNodeFilter.install(this.mbeanTreeViewer, this.filterText, mriCount > 5000);
    }

    protected int getTreeStyle() {
        int style = 2048;
        style = this.m_viewModel.isMultiSelectionAllowed() ? (style |= 2) : (style |= 4);
        return style;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, this.getTreeStyle());
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(this.m_viewModel.getContentType()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        return viewer;
    }

    private void initComponent() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        Composite filterAreaComposite = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterAreaComposite.setLayout((Layout)filterLayout);
        filterAreaComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label filterLabel = new Label(filterAreaComposite, 0);
        filterLabel.setText(Messages.AttributeSelectorDialog_LABEL_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.filterText = new Text(filterAreaComposite, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mbeanTreeViewer = this.createTreeViewer(this);
        this.mbeanTreeViewer.setUseHashlookup(true);
        this.mbeanTreeViewer.setSorter((ViewerSorter)new MBeanTreeSorter());
        this.mbeanTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<IMRIMetaData> addList = new ArrayList<IMRIMetaData>();
                ArrayList<MRI> selectedAttributes = new ArrayList<MRI>();
                for (Object o : ((IStructuredSelection)event.getSelection()).toList()) {
                    Object e = ((ITreeNode)o).getUserData();
                    if (!(e instanceof IMRIMetaData)) continue;
                    addList.add((IMRIMetaData)e);
                }
                int i = 0;
                while (i < addList.size()) {
                    IMRIMetaData metaData = (IMRIMetaData)addList.get(i);
                    if (!MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)metaData)) {
                        String unitString = metaData.getUnitString();
                        if (AttributeSelectorComponent.this.m_viewModel.getContentType() == null || unitString == null || AttributeSelectorComponent.this.m_viewModel.getContentType().equals((Object)UnitLookup.getContentType((String)unitString))) {
                            selectedAttributes.add(metaData.getMRI());
                        }
                    } else if (AttributeSelectorComponent.this.m_viewModel.isMultiSelectionAllowed()) {
                        for (MRI child : AttributeSelectorComponent.this.m_selectorModel.getAvailableAttributes()) {
                            if (!MRIMetaDataToolkit.isChild((MRI)child, (MRI)metaData.getMRI())) continue;
                            IMRIMetaData childMd = AttributeSelectorComponent.this.m_selectorModel.getMetaDataService().getMetaData(child);
                            if (AttributeSelectorComponent.this.m_viewModel.isNumericalOnly() && !MRIMetaDataToolkit.isNumerical((IMRIMetaData)childMd)) continue;
                            addList.add(childMd);
                        }
                    }
                    ++i;
                }
                AttributeSelectorComponent.this.m_selectorModel.setSelectedAttributes(selectedAttributes.toArray(new MRI[selectedAttributes.size()]));
                AttributeSelectorComponent.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AttributeSelectorComponent.this.mbeanTreeViewer, (ISelection)new StructuredSelection((Object[])AttributeSelectorComponent.this.getSelection())));
            }
        });
        this.mbeanTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                AttributeSelectorComponent.this.mbeanTreeViewer.setExpandedState(element, !AttributeSelectorComponent.this.mbeanTreeViewer.getExpandedState(element));
            }
        });
        this.mbeanTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
    }
}

