/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.util;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.tab.ImageConverter;

public class ImageDescriptor {
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String ENCODING = "encoding";
    private static final String IMAGE_DATA = "imageData";
    private final Setting m_setting = new Setting("image");
    public static final String RGBA = "RGBA";

    static {
        PersistenceToolkit.registerFetcher(ImageDescriptor.class, (ISettingFetcher)new ISettingFetcher<ImageDescriptor>(){

            public Setting getSetting(ImageDescriptor imageDescriptor) {
                return imageDescriptor.m_setting;
            }
        });
    }

    public ImageDescriptor() {
        this.setWidth(0);
        this.setHeight(0);
        this.setEncoding(RGBA);
        this.setImageData("");
    }

    public static ImageDescriptor createWithSize(int width, int height) {
        return ImageConverter.createDefault(width, height);
    }

    public int getHeight() {
        return (Integer)this.m_setting.getChildObject(HEIGHT, Integer.class);
    }

    public int getWidth() {
        return (Integer)this.m_setting.getChildObject(WIDTH, Integer.class);
    }

    public void setHeight(int height) {
        this.m_setting.setChildObject(HEIGHT, (Object)height);
    }

    public void setWidth(int width) {
        this.m_setting.setChildObject(WIDTH, (Object)width);
    }

    public void setEncoding(String encoding) {
        this.m_setting.setChildObject(ENCODING, (Object)encoding);
    }

    public void setImageData(String imageData) {
        this.m_setting.setChildObject(IMAGE_DATA, (Object)imageData);
    }

    public String getEncoding() {
        return (String)this.m_setting.getChildObject(ENCODING, String.class);
    }

    public String getImageData() {
        return (String)this.m_setting.getChildObject(IMAGE_DATA, String.class);
    }
}

