/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.range.JComponentNavigator;
import com.jrockit.mc.flightrecorder.ui.components.range.NavigatorListener;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DateFormat;
import javax.swing.JComponent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SelectRangeWizardPage
extends WizardPage
implements IPerformFinishable {
    private JComponentNavigator m_slider;
    private final long m_startTime;
    private final long m_duration;
    private final long m_endTime;
    private final DateFormat m_timeFormatter;
    private Label m_selectedStartLabel;
    private Label m_selectedEndLabel;
    private Label m_warningLabel;
    private FormToolkit m_toolkit;
    private ITimeRange m_selectedRange;
    private final double m_loadQuota;

    public SelectRangeWizardPage(double loadQuota, ITimeRange range) {
        super("SelectRangeWizardPage", Messages.SELECT_RANGE_WIZARD_TITLE, null);
        this.m_startTime = range.getStartTimestamp();
        this.m_endTime = range.getEndTimestamp();
        this.m_duration = range.getDuration();
        this.m_timeFormatter = DateFormat.getDateTimeInstance(3, 2);
        this.m_loadQuota = loadQuota;
    }

    public void createControl(Composite parent) {
        this.m_toolkit = new FormToolkit(parent.getDisplay());
        this.initializeDialogUnits((Control)parent);
        int indent = 0;
        this.setDescription(Messages.SELECT_RANGE_WIZARD_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createHeader(container);
        this.createTimeLabels(container);
        this.createSlider(container, indent);
        this.createSelectedTimeLabels(container, indent);
        this.m_warningLabel = new Label(container, 16384);
        this.m_warningLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.m_warningLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        this.setControl((Control)container);
        this.m_slider.setSelectedArea(1.0 - this.m_loadQuota, 1.0);
        this.updateLabels(1.0 - this.m_loadQuota, 1.0);
    }

    private void createHeader(Composite parent) {
        Label start = new Label(parent, 0x1000000);
        start.setText(Messages.SELECT_RANGE_WIZARD_TEXT);
        GridData g = new GridData(0x1000000, 0x1000000, true, false);
        g.horizontalSpan = 2;
        start.setLayoutData((Object)g);
    }

    private void createTimeLabels(Composite parent) {
        Label start = new Label(parent, 16384);
        start.setText(this.m_timeFormatter.format(this.m_startTime / 1000000L));
        start.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label end = new Label(parent, 131072);
        end.setText(this.m_timeFormatter.format(this.m_endTime / 1000000L));
        end.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
    }

    private void createSelectedTimeLabels(Composite parent, int indent) {
        this.m_selectedStartLabel = new Label(parent, 16384);
        this.m_selectedStartLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.m_selectedEndLabel = new Label(parent, 131072);
        this.m_selectedEndLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
    }

    private GridData createGridData(boolean grabExcessHorizontalSpace, int horizontalSpan, int indent) {
        GridData gridData = new GridData(4, 0x1000000, grabExcessHorizontalSpace, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalIndent = indent;
        return gridData;
    }

    private void createSlider(Composite parent, int indent) {
        this.m_slider = new JComponentNavigator(parent, this.m_toolkit, new JComponent(){
            private static final long serialVersionUID = 1L;
            private final Color RED = Color.getHSBColor(0.0f, 0.9f, 0.9f);
            private final Color ORANGE = Color.getHSBColor(0.1f, 0.9f, 0.8f);

            @Override
            public void paint(Graphics g) {
                int w = this.getSize().width;
                int h = this.getSize().height;
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, h);
                Graphics2D g2d = (Graphics2D)g;
                GradientPaint gradient = new GradientPaint(0.0f, (float)h / 2.0f, this.RED, 0.0f, h, this.ORANGE, false);
                g2d.setPaint(gradient);
                g.fillRect(2, h / 3, w - 4, h);
            }
        });
        this.m_slider.setNavigatorRange(0.0, 1.0);
        this.m_slider.addSelectionListener(new NavigatorListener(){

            @Override
            public void onNavigatorChange(Object source, double minX, double maxX) {
                SelectRangeWizardPage.this.updateLabels(minX, maxX);
            }
        });
        this.m_slider.setLayoutData(this.createGridData(true, 2, indent));
    }

    private void updateLabels(double minX, double maxX) {
        this.m_selectedRange = new TimeRange(this.getTimestamp(minX), this.getTimestamp(maxX));
        this.m_selectedStartLabel.setText(this.m_timeFormatter.format(this.m_selectedRange.getStartTimestamp() / 1000000L));
        this.m_selectedEndLabel.setText(this.m_timeFormatter.format(this.m_selectedRange.getEndTimestamp() / 1000000L));
        if (this.m_loadQuota - maxX + minX < -0.01) {
            this.m_warningLabel.setText(Messages.SELECT_RANGE_WIZARD_TO_MUCH_SELECTED_WARNING);
        } else {
            this.m_warningLabel.setText("");
        }
        this.m_warningLabel.getParent().layout();
    }

    private long getTimestamp(double pos) {
        return this.m_startTime + (long)((double)this.m_duration * pos);
    }

    public ITimeRange getRange() {
        return this.m_selectedRange;
    }

    public void dispose() {
        super.dispose();
        if (this.m_toolkit != null) {
            this.m_toolkit.dispose();
        }
    }

    public boolean performFinish() {
        return true;
    }
}

