/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class DnDInfo {
    Point cursorPos;
    Control curCtrl;
    Item curItem;
    MUIElement curElement;
    MUIElement itemElement;
    int itemIndex;
    Rectangle itemRect;
    Shell dragHost = null;
    int offsetX = 0;
    int offsetY = 0;
    Rectangle dragHostBounds = null;
    Point initialHostSize;
    MWindow topLevelWindow;
    Display display;
    EModelService modelService;

    public DnDInfo(MWindow topWin) {
        this.topLevelWindow = topWin;
        this.display = ((Control)topWin.getWidget()).getDisplay();
        this.modelService = (EModelService)topWin.getContext().get(EModelService.class);
        this.update();
    }

    public void setDragHost(Shell hostingShell, int xOffset, int yOffset) {
        this.dragHost = hostingShell;
        this.offsetX = xOffset;
        this.offsetY = yOffset;
        this.dragHostBounds = null;
        if (this.dragHost == null) {
            return;
        }
        Region rgn = this.dragHost.getRegion();
        Rectangle bounds = this.dragHost.getBounds();
        rgn.add(0, 0, bounds.width, bounds.height);
        rgn.subtract(this.offsetX, this.offsetY, 1, 1);
        this.dragHost.setRegion(rgn);
        this.initialHostSize = this.dragHost.getSize();
        Point curLoc = this.dragHost.getDisplay().getCursorLocation();
        this.dragHost.setLocation(curLoc.x - this.offsetX, curLoc.y - this.offsetY);
        this.dragHost.layout(true);
    }

    public void setDragHostBounds(Rectangle displayRect) {
        if (this.dragHost == null) {
            return;
        }
        this.dragHostBounds = displayRect;
        if (this.dragHostBounds == null) {
            this.dragHost.setSize(this.initialHostSize);
            this.setDragHost(this.dragHost, this.offsetX, this.offsetY);
            return;
        }
        this.dragHost.setAlpha(200);
        this.dragHost.setBounds(this.dragHostBounds);
        Point cursorLoc = this.display.getCursorLocation();
        cursorLoc = this.display.map(null, (Control)this.dragHost, cursorLoc);
        Region rgn = this.dragHost.getRegion();
        Rectangle bounds = this.dragHost.getBounds();
        rgn.add(0, 0, bounds.width, bounds.height);
        rgn.subtract(cursorLoc.x, cursorLoc.y, 1, 1);
        this.display.update();
    }

    private void reset() {
        this.cursorPos = null;
        this.curCtrl = null;
        this.curItem = null;
        this.curElement = null;
        this.itemElement = null;
        this.itemIndex = -1;
        this.itemRect = null;
    }

    private void setItemInfo() {
        Point localPos;
        ToolBar tb;
        ToolItem curItem;
        if (this.curElement == null) {
            return;
        }
        Control ctrl = (Control)this.curElement.getWidget();
        if (ctrl instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)ctrl;
            Point localPos2 = this.display.map(null, (Control)ctf, this.cursorPos);
            this.curItem = ctf.getItem(localPos2);
            if (this.curItem != null) {
                this.itemElement = (MUIElement)this.curItem.getData("modelElement");
                if (this.itemElement != null) {
                    this.itemIndex = ctf.indexOf((CTabItem)this.curItem);
                    this.itemRect = this.display.map((Control)ctf, (Control)ctf.getShell(), ((CTabItem)this.curItem).getBounds());
                }
            }
        } else if (ctrl instanceof ToolBar && (curItem = (tb = (ToolBar)ctrl).getItem(localPos = this.display.map(null, (Control)tb, this.cursorPos))) != null) {
            this.itemElement = (MUIElement)curItem.getData("modelElement");
            if (this.itemElement != null) {
                this.itemIndex = tb.indexOf(curItem);
                this.itemRect = this.display.map((Control)tb, (Control)tb.getShell(), curItem.getBounds());
            }
        }
    }

    private MUIElement getModelElement(Control ctrl) {
        if (ctrl == null) {
            return null;
        }
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        if (element != null) {
            return element;
        }
        return this.getModelElement((Control)ctrl.getParent());
    }

    public void update() {
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Point cPoint = display.getCursorLocation();
        if (cPoint != null && this.cursorPos != null && cPoint.x == this.cursorPos.x && cPoint.y == this.cursorPos.y) {
            return;
        }
        this.reset();
        this.cursorPos = display.getCursorLocation();
        if (this.dragHost != null && !this.dragHost.isDisposed() && this.dragHost.getVisible()) {
            if (this.dragHostBounds == null) {
                this.dragHost.setLocation(this.cursorPos.x - this.offsetX, this.cursorPos.y - this.offsetY);
            } else {
                Point cursorLoc = display.getCursorLocation();
                cursorLoc = display.map(null, (Control)this.dragHost, cursorLoc);
                Region rgn = this.dragHost.getRegion();
                Rectangle bounds = this.dragHost.getBounds();
                rgn.add(0, 0, bounds.width, bounds.height);
                rgn.subtract(cursorLoc.x, cursorLoc.y, 1, 1);
            }
        }
        this.curCtrl = display.getCursorControl();
        if (this.curCtrl == null) {
            return;
        }
        this.curElement = this.getModelElement(this.curCtrl);
        this.setItemInfo();
    }

    public void update(DragDetectEvent e) {
        this.reset();
        if (!(e.widget instanceof Control)) {
            return;
        }
        this.curCtrl = (Control)e.widget;
        this.cursorPos = new Point(e.x, e.y);
        this.cursorPos = this.curCtrl.getDisplay().map(this.curCtrl, null, this.cursorPos);
        this.curElement = this.getModelElement(this.curCtrl);
        this.setItemInfo();
    }
}

