/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.behaviors.IComponent;
import com.jrockit.mc.components.ui.behaviors.IComponentDecoration;
import com.jrockit.mc.components.ui.behaviors.IComponentDescribable;
import com.jrockit.mc.components.ui.behaviors.ICreateAccessiblePart;
import com.jrockit.mc.components.ui.behaviors.ICreatePart;
import com.jrockit.mc.components.ui.behaviors.ILayoutAware;
import com.jrockit.mc.components.ui.behaviors.IToolbar;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptorCategory;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.ComponentHolder;
import com.jrockit.mc.components.ui.design.IComponentVerifier;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.StandardSectionPart;
import com.jrockit.mc.components.ui.design.UnknownComponent;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.util.Dynamic;
import com.jrockit.mc.components.ui.util.HelpToolkit;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.misc.MCToolBarManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class GUIFactory {
    private final FormToolkit m_toolkit;
    private final IServiceLocator m_locator;

    private GUIFactory(IServiceLocator locator) {
        this.m_locator = locator;
        this.m_toolkit = this.m_locator.getService(FormToolkit.class);
    }

    public static GUIFactory createChildFactory(IServiceLocator locator) {
        UIScope s = locator.getService(UIScope.class);
        UIScope comp = new UIScope(s);
        locator.registerService(comp);
        IServiceLocator childService = locator.createChildService();
        return new GUIFactory(childService);
    }

    public static GUIFactory createFactory(IServiceLocator locator) {
        return new GUIFactory(locator);
    }

    public Control buildUI(Composite parent, LayoutItem item) {
        Control control = this.createSection(parent, item);
        control.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        return control;
    }

    /*
     * Unable to fully structure code
     */
    private Control createSection(Composite parent, LayoutItem item) {
        try {
            ch = this.createDisposableComponent(item, parent);
            if (ch.component != null) {
                this.addComponentToScope(ch.component);
            }
            return ch.control;
        }
        catch (Exception e) {
            var7_5 = parent.getChildren();
            var6_6 = var7_5.length;
            var5_7 = 0;
            ** while (var5_7 < var6_6)
        }
lbl-1000:
        // 1 sources

        {
            child = var7_5[var5_7];
            if (child != null && !child.isDisposed()) {
                child.dispose();
            }
            ++var5_7;
            continue;
        }
lbl16:
        // 1 sources

        componentName = item.getComponentDescriptor() != null ? item.getComponentDescriptor().getIdentifier() : "null";
        return this.createExceptionComponent(parent, "Error initializing component: " + componentName, e);
    }

    public void addComponentToScope(Object component) {
        UIScope comps = this.getServiceLocator().getService(UIScope.class);
        comps.addComponent(component);
    }

    public ComponentHolder createDisposableComponent(LayoutItem item, Composite disposeParent) {
        ComponentTypeDescriptorCategory ctdc;
        ComponentDescriptor cd = item.getComponentDescriptor();
        ComponentHolder ch = this.createComponent(item);
        String title = null;
        String description = null;
        Color descrptionColor = null;
        int style = 0;
        if (ch.component != null) {
            ILayoutAware la;
            IComponentDecoration deco = Dynamic.cast(ch.component, IComponentDecoration.class);
            if (deco != null) {
                String error;
                title = deco.getTitle();
                description = deco.getDescription();
                IComponentVerifier verifier = this.getServiceLocator().getService(IComponentVerifier.class);
                if (verifier != null && (error = verifier.getErrorMessage(ch.component)) != null) {
                    descrptionColor = JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
                    description = error;
                }
                style = this.determineStyle(title, description);
            }
            if ((la = Dynamic.cast(ch.component, ILayoutAware.class)) != null) {
                la.initialize(item);
            }
        }
        if ((ctdc = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptorCategory(cd)) == null) {
            throw new RuntimeException("Unknown component type " + cd.getTypeIdentifier());
        }
        if (!ctdc.isContainer()) {
            IToolbar t;
            StandardSectionPart section = new StandardSectionPart(this.m_toolkit, disposeParent, style);
            section.setText("");
            this.getToolkit().adapt((Composite)section);
            if (ch.component instanceof IToolbar && ch.serviceLocator != null && (t = (IToolbar)ch.component).supportsToolbar()) {
                this.createToolbar(section, cd, ch.serviceLocator, t);
            }
            this.setTitleAndDescription(ch.component, section, title, description);
            Control control = this.createComponentControl((Composite)section, ch.component, cd);
            this.getToolkit().adapt(control, false, false);
            section.setClient(control);
            if (section.getDescriptionControl() != null && descrptionColor != null) {
                section.getDescriptionControl().setForeground(descrptionColor);
            }
            ch.control = section;
        } else {
            Control control;
            ch.control = control = this.createComponentControl(disposeParent, ch.component, cd);
            this.getToolkit().adapt(control, true, true);
        }
        return ch;
    }

    private void setTitleAndDescription(Object component, Section section, String title, String description) {
        if (component != null) {
            if (title != null) {
                section.setText(title);
            }
            if (this.hasValidText(description)) {
                section.setDescription(description);
            }
        }
    }

    protected MCToolBarManager createToolbar(Section parent, ComponentDescriptor cd, IServiceLocator locetor, IToolbar tb) {
        MCToolBarManager mct = new MCToolBarManager((Composite)parent);
        parent.setTextClient((Control)mct.getToolBar());
        locetor.registerService(mct);
        tb.initializeToolbar(mct);
        return mct;
    }

    private int determineStyle(String title, String description) {
        int style = 0;
        if (this.hasValidText(description)) {
            style |= 0x80;
        }
        style = !this.hasValidText(title) ? (style |= 0x1000) : (style |= 0x140);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            style |= 8;
        }
        return style;
    }

    private boolean hasValidText(String text) {
        return text != null && text.trim().length() != 0;
    }

    public Control createComponentControl(Composite parent, Object component, ComponentDescriptor cd) {
        Control control = null;
        control = component != null ? this.initializeCreatePart(parent, component, cd) : new UnknownComponent().createPart(parent);
        return control;
    }

    public ComponentHolder createComponent(LayoutItem item) {
        ComponentHolder holder = new ComponentHolder();
        holder.serviceLocator = this.getServiceLocator().createChildService();
        ComponentDescriptor cd = item.getComponentDescriptor();
        holder.component = cd.createComponent();
        if (holder.component == null) {
            holder.component = new UnknownComponent();
        }
        this.initializePersistence(cd, holder.component);
        this.initializeComponent(holder.component, holder.serviceLocator);
        return holder;
    }

    private Control initializeCreatePart(Composite parent, Object object, ComponentDescriptor cd) {
        Control control = null;
        ICreateAccessiblePart aPart = Dynamic.cast(object, ICreateAccessiblePart.class);
        if (aPart != null && UIPlugin.getDefault().getAccessibilityMode()) {
            control = aPart.createAccessiblePart(parent);
        } else {
            ICreatePart part = Dynamic.cast(object, ICreatePart.class);
            if (part != null) {
                control = part.createPart(parent);
                this.addHelp(cd, control);
            }
        }
        return control;
    }

    private void addHelp(final ComponentDescriptor cd, Control control) {
        control.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                HelpToolkit.openHelp(cd.getGUID());
            }
        });
    }

    private Control createExceptionComponent(Composite parent, String errorMessage, Exception e) {
        Composite container = this.m_toolkit.createComposite(parent);
        this.m_toolkit.paintBordersFor(container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        CLabel errorLabel = new CLabel(container, 0);
        errorLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        errorLabel.setText(errorMessage);
        errorLabel.setLayoutData((Object)gd1);
        this.m_toolkit.adapt((Composite)errorLabel);
        GridData gd3 = new GridData(4, 4, true, false);
        CLabel helpLabel = new CLabel(container, 0);
        helpLabel.setText(Messages.GUI_FACTORY_COMPONENT_EXCEPTION_TEXT);
        helpLabel.setLayoutData((Object)gd3);
        this.m_toolkit.adapt((Composite)helpLabel);
        GridData gd2 = new GridData(4, 4, true, true);
        Text text = this.m_toolkit.createText(container, this.formatException(e), 514);
        text.setLayoutData((Object)gd2);
        return container;
    }

    private String formatException(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void initializePersistence(ComponentDescriptor cd, Object o) {
        IComponentDescribable persistable = Dynamic.cast(o, IComponentDescribable.class);
        if (persistable != null) {
            persistable.initialize(cd);
        }
    }

    private void initializeComponent(Object o, IServiceLocator sl) {
        IComponent component = Dynamic.cast(o, IComponent.class);
        if (component != null) {
            component.initialize(sl);
        }
    }

    private FormToolkit getToolkit() {
        return this.m_toolkit;
    }

    IServiceLocator getServiceLocator() {
        return this.m_locator;
    }
}

