/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.formpage;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.formpage.FormPageContribution;
import com.jrockit.mc.ui.formpage.FormPageContributionGroup;
import com.jrockit.mc.ui.formpage.FormPageContributionItem;
import com.jrockit.mc.ui.formpage.IFormPageSupportTester;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FormPageContributionFactory {
    private static final String EXTENSION_PLUGIN = "com.jrockit.mc.core";
    private static final String EXTENSION_POINT = "com.jrockit.mc.core.formpage";
    private static final String EXTENSION_ELEMENT_FORMPAGE = "formpage";
    public static final String FORMPAGE_ATTRIBUTE_CLASS = "class";
    private static final String FORMPAGE_ATTRIBUTE_GROUP_ID = "groupId";
    public static final String SHARED_ATTRIBUTE_ID = "id";
    private static final String SHARED_ATTRIBUTE_TITLE = "title";
    private static final String SHARED_ATTRIBUTE_EDITOR_ID = "hostEditorId";
    private static final String SHARED_ATTRIBUTE_ICON = "icon";
    private static final String SHARED_ATTRIBUTE_PLACEMENT = "placement";
    private static final String SHARED_ATTRIBUTE_IS_SUPPORTED = "isSupportedClass";
    private static final String EXTENSION_ELEMENT_GROUP = "group";
    private static final String GROUP_ATTRIBUTE_LARGE_ICON = "largeIcon";
    private final Logger logger;
    private final Map<String, FormPageContributionGroup> idToGroup;
    private final Object serviceLocator;
    private final String editorId;

    public FormPageContributionFactory(Object locator, String editorID) {
        this.serviceLocator = locator;
        this.editorId = editorID;
        this.logger = UIPlugin.getDefault().getLogger();
        this.idToGroup = new HashMap<String, FormPageContributionGroup>();
    }

    public void addFormPageContributionsTo(List<FormPageContribution> contribs) {
        this.idToGroup.clear();
        for (FormPageContribution contrib : contribs) {
            if (!(contrib instanceof FormPageContributionGroup)) continue;
            this.idToGroup.put(contrib.getId(), (FormPageContributionGroup)contrib);
        }
        this.addFromExtensionPoint(contribs, EXTENSION_POINT);
    }

    private void addFromExtensionPoint(List<FormPageContribution> contribs, String extensionPoint) {
        try {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint exPoint = registry.getExtensionPoint(extensionPoint);
            IExtension[] iExtensionArray = extensions = exPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (this.isOurEditor(element) && this.isSupportedByEditor(element)) {
                        String elementName = element.getName();
                        if (elementName.equalsIgnoreCase(EXTENSION_ELEMENT_FORMPAGE)) {
                            this.addContributedItem(contribs, element);
                        } else if (elementName.equalsIgnoreCase(EXTENSION_ELEMENT_GROUP)) {
                            this.addContributedGroup(contribs, element);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception iroe) {
            this.getLogger().log(Level.SEVERE, "Error when examining extension point " + extensionPoint, iroe);
        }
    }

    private Logger getLogger() {
        return this.logger;
    }

    private boolean isOurEditor(IConfigurationElement element) {
        return this.editorId.equals(element.getAttribute(SHARED_ATTRIBUTE_EDITOR_ID));
    }

    private boolean isSupportedByEditor(IConfigurationElement element) {
        String isSupportedClass = element.getAttribute(SHARED_ATTRIBUTE_IS_SUPPORTED);
        if (isSupportedClass == null) {
            return true;
        }
        try {
            IFormPageSupportTester tester = (IFormPageSupportTester)element.createExecutableExtension(SHARED_ATTRIBUTE_IS_SUPPORTED);
            return tester.isSupported(this.serviceLocator);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error when create formpage is supported contribution for extension pointcom.jrockit.mc.core.formpage", e);
            return false;
        }
    }

    private Image createImage(IConfigurationElement configElement, String name) {
        Image image = null;
        try {
            String iconName = configElement.getAttribute(SHARED_ATTRIBUTE_ICON);
            if (iconName != null) {
                IExtension extension = configElement.getDeclaringExtension();
                String extendingPluginId = extension.getContributor().getName();
                ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconName);
                image = desc.createImage();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Could not load image for FormPage with label " + name);
        }
        return image;
    }

    private void addContributedItem(List<FormPageContribution> contribs, IConfigurationElement formPageElement) {
        try {
            IFormPage page = (IFormPage)formPageElement.createExecutableExtension(FORMPAGE_ATTRIBUTE_CLASS);
            if (page != null) {
                String id = formPageElement.getAttribute(SHARED_ATTRIBUTE_ID);
                FormPageContributionItem leaf = new FormPageContributionItem(id, page);
                leaf.setLabel(formPageElement.getAttribute(SHARED_ATTRIBUTE_TITLE));
                leaf.setPlacementPath(formPageElement.getAttribute(SHARED_ATTRIBUTE_PLACEMENT));
                String image = formPageElement.getAttribute(SHARED_ATTRIBUTE_ICON);
                if (image != null) {
                    leaf.setIcon(this.createImage(formPageElement, image), true);
                }
                leaf.setVisible(Boolean.TRUE);
                String groupId = formPageElement.getAttribute(FORMPAGE_ATTRIBUTE_GROUP_ID);
                if (groupId != null) {
                    FormPageContributionGroup group = this.getOrCreateGroup(contribs, groupId);
                    group.add(leaf);
                } else {
                    contribs.add(leaf);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error when create formPage contribution for extension pointcom.jrockit.mc.core.formpage", e);
        }
    }

    private FormPageContributionGroup getOrCreateGroup(List<FormPageContribution> contribs, String groupId) {
        FormPageContributionGroup group = this.idToGroup.get(groupId);
        if (group == null) {
            group = new FormPageContributionGroup(groupId);
            this.idToGroup.put(groupId, group);
            contribs.add(group);
        }
        return group;
    }

    private void addContributedGroup(List<FormPageContribution> contribs, IConfigurationElement groupElement) {
        try {
            String groupId = groupElement.getAttribute(SHARED_ATTRIBUTE_ID);
            if (groupId != null) {
                String largeImage;
                FormPageContributionGroup group = this.getOrCreateGroup(contribs, groupId);
                if (Boolean.TRUE.equals(group.getVisible())) {
                    this.getLogger().warning("Form page group '" + groupId + "' for editor '" + this.editorId + "' defined more than once.");
                }
                group.setLabel(groupElement.getAttribute(SHARED_ATTRIBUTE_TITLE));
                group.setPlacementPath(groupElement.getAttribute(SHARED_ATTRIBUTE_PLACEMENT));
                String image = groupElement.getAttribute(SHARED_ATTRIBUTE_ICON);
                if (image != null) {
                    group.setIcon(this.createImage(groupElement, image), true);
                }
                if ((largeImage = groupElement.getAttribute(GROUP_ATTRIBUTE_LARGE_ICON)) != null) {
                    group.setLargeIcon(this.createImage(groupElement, image), true);
                }
                group.setVisible(Boolean.TRUE);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error when create formPage contribution for extension pointcom.jrockit.mc.core.formpage", e);
        }
    }
}

