/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.core.ui.components.Spacer;
import com.sun.tools.visualvm.profiler.JavaInfo;
import com.sun.tools.visualvm.profiler.JavaPlatformCache;
import com.sun.tools.visualvm.uisupport.HTMLTextArea;
import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.global.Platform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class JavaPlatformSelector
extends JPanel {
    private static JavaPlatformSelector defaultInstance;
    private HTMLTextArea hintArea;
    private JTextField javaPlatformFileField;
    private JButton snapshotFileButton;
    private JButton okButton;

    static String selectJavaBinary(String javaName, String archName, String java, String arch) {
        JavaPlatformSelector hc = JavaPlatformSelector.getDefault();
        hc.setupSelectJavaPlatform(javaName, archName, java, arch);
        DialogDescriptor dd = new DialogDescriptor((Object)hc, NbBundle.getMessage(JavaPlatformSelector.class, (String)"CAP_Calibrate_java"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            String javaBinary = hc.getJavaBinary();
            File javaBinaryF = new File(javaBinary);
            if (arch == null) {
                String[] props = JavaInfo.getSystemProperties(javaBinaryF, "java.version");
                if (props == null || props.length < 1 || !java.equals(Platform.getJDKVersionString((String)props[0]))) {
                    JavaPlatformSelector.notifyWrongBinary(javaName, archName);
                    javaBinary = null;
                }
            } else {
                String[] props = JavaInfo.getSystemProperties(javaBinaryF, "java.version", "sun.arch.data.model");
                if (props == null || props.length < 2 || !java.equals(Platform.getJDKVersionString((String)props[0])) || !arch.equals(props[1])) {
                    JavaPlatformSelector.notifyWrongBinary(javaName, archName);
                    javaBinary = null;
                }
            }
            if (javaBinary == null) {
                return JavaPlatformSelector.selectJavaBinary(javaName, archName, java, arch);
            }
            if (javaBinaryF.isFile()) {
                JavaPlatformCache.setBinary(java, arch, javaBinary);
            }
            return javaBinary;
        }
        return null;
    }

    private static void notifyWrongBinary(String javaName, String archName) {
        String msg = archName != null ? NbBundle.getMessage(JavaPlatformSelector.class, (String)"MSG_Incorrect_java_binary_arch", (Object)javaName, (Object)archName) : NbBundle.getMessage(JavaPlatformSelector.class, (String)"MSG_Incorrect_java_binary_noarch", (Object)javaName);
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private String getJavaBinary() {
        return this.javaPlatformFileField.getText().trim();
    }

    private JavaPlatformSelector() {
        this.initComponents();
        this.update();
    }

    private static synchronized JavaPlatformSelector getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new JavaPlatformSelector();
        }
        return defaultInstance;
    }

    private void setupSelectJavaPlatform(String javaName, String archName, String java, String arch) {
        if (archName != null) {
            this.hintArea.setText(NbBundle.getMessage(JavaPlatformSelector.class, (String)"MSG_Calibration_required_arch", (Object)javaName, (Object)archName));
        } else {
            this.hintArea.setText(NbBundle.getMessage(JavaPlatformSelector.class, (String)"MSG_Calibration_required_noarch", (Object)javaName));
        }
        String binary = JavaPlatformCache.getBinary(java, arch);
        if (binary == null || !new File(binary).isFile()) {
            this.javaPlatformFileField.setText("");
            if (binary != null) {
                JavaPlatformCache.clearBinary(java, arch);
            }
        } else {
            this.javaPlatformFileField.setText(binary);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaPlatformSelector.this.javaPlatformFileField.selectAll();
                JavaPlatformSelector.this.javaPlatformFileField.requestFocusInWindow();
            }
        });
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                File snapshotFile = new File(JavaPlatformSelector.this.getJavaBinary());
                JavaPlatformSelector.this.okButton.setEnabled(snapshotFile.isFile());
            }
        });
    }

    private void chooseSnapshot() {
        JFileChooser chooser = new JFileChooser();
        chooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
        chooser.setDialogTitle(NbBundle.getMessage(JavaPlatformSelector.class, (String)"CAP_Select_java_binary"));
        chooser.setSelectedFile(new File(this.getJavaBinary()));
        if (Platform.isWindows()) {
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new FileFilter(){
                private String java = "java.exe";

                public boolean accept(File f) {
                    return f.isDirectory() || f.isFile() && this.java.equals(f.getName());
                }

                public String getDescription() {
                    return NbBundle.getMessage(JavaPlatformSelector.class, (String)"LBL_Java_file_filter", (Object)this.java);
                }
            });
        } else {
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new FileFilter(){
                private String java = "java";

                public boolean accept(File f) {
                    return f.isDirectory() || f.isFile() && this.java.equals(f.getName());
                }

                public String getDescription() {
                    return NbBundle.getMessage(JavaPlatformSelector.class, (String)"LBL_Java_file_filter", (Object)this.java);
                }
            });
        }
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            this.javaPlatformFileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.hintArea = new HTMLTextArea();
        this.hintArea.setOpaque(false);
        if (UISupport.isNimbusLookAndFeel()) {
            this.hintArea.setBackground(new Color(0, 0, 0, 0));
        }
        this.hintArea.setCaret((Caret)new NullCaret());
        this.hintArea.setBorder(BorderFactory.createEmptyBorder());
        this.hintArea.setFocusable(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(15, 10, 0, 10);
        this.add((Component)this.hintArea, constraints);
        this.javaPlatformFileField = new JTextField();
        this.javaPlatformFileField.setPreferredSize(new Dimension(220, this.javaPlatformFileField.getPreferredSize().height));
        this.javaPlatformFileField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JavaPlatformSelector.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                JavaPlatformSelector.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                JavaPlatformSelector.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.javaPlatformFileField, constraints);
        this.snapshotFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.snapshotFileButton, (String)NbBundle.getMessage(JavaPlatformSelector.class, (String)"BTN_Browse"));
        this.snapshotFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaPlatformSelector.this.chooseSnapshot();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.snapshotFileButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)Spacer.create(), constraints);
        this.okButton = new JButton(NbBundle.getMessage(JavaPlatformSelector.class, (String)"BTN_Ok"));
    }

    private static final class NullCaret
    implements Caret {
        private NullCaret() {
        }

        public void install(JTextComponent c) {
        }

        public void deinstall(JTextComponent c) {
        }

        public void paint(Graphics g) {
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean v) {
        }

        public boolean isSelectionVisible() {
            return false;
        }

        public void setSelectionVisible(boolean v) {
        }

        public void setMagicCaretPosition(Point p) {
        }

        public Point getMagicCaretPosition() {
            return new Point(0, 0);
        }

        public void setBlinkRate(int rate) {
        }

        public int getBlinkRate() {
            return 0;
        }

        public int getDot() {
            return 0;
        }

        public int getMark() {
            return 0;
        }

        public void setDot(int dot) {
        }

        public void moveDot(int dot) {
        }
    }
}

