/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.wizard;

import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.wizard.Messages;
import com.jrockit.mc.console.ui.notification.wizard.RuleWizard;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.ui.uibuilder.StandardUIBuilder;
import java.util.HashSet;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NameWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "com.jrockit.mc.notification.trigger.name";
    private final TriggerRule m_notificationRule;
    private Text text;
    private final String m_defaultName;

    public NameWizardPage(NotificationRegistry notificationModel, TriggerRule rule) {
        super(PAGE_NAME, Messages.NameWizardPage_TITLE, null);
        this.setDescription(Messages.NameWizardPage_DESCRIPTION);
        this.m_defaultName = rule.getName() == null ? Messages.NameWizardPage_DEFAULT_TRIGGER_NAME : rule.getName();
        this.m_notificationRule = rule;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.text.getText().equals(this.m_defaultName)) {
            this.text.setText(((RuleWizard)this.getWizard()).getSuggestedName());
        }
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        StandardUIBuilder suib = new StandardUIBuilder(c);
        suib.createLabel(Messages.NameWizardPage_RULE_GROUP_NAME_TEXT, null);
        final CCombo combo = suib.createCombo();
        final HashSet<String> names = new HashSet<String>();
        HashSet<String> set = new HashSet<String>();
        for (TriggerRule rule : NotificationPlugin.getDefault().getNotificationRepository().getAvailableRules()) {
            set.add(rule.getRulePath());
            names.add(rule.getName());
        }
        if (!set.contains(this.m_notificationRule.getRulePath())) {
            combo.add(this.m_notificationRule.getRulePath());
        }
        for (String path : set) {
            combo.add(path);
        }
        int i = 0;
        while (i < combo.getItems().length) {
            if (this.m_notificationRule.getRulePath().equals(combo.getItem(i))) {
                combo.select(i);
            }
            ++i;
        }
        combo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                NameWizardPage.this.m_notificationRule.setRulePath(combo.getText());
            }
        });
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                if (index >= 0) {
                    NameWizardPage.this.m_notificationRule.setRulePath(combo.getText());
                }
            }
        });
        suib.layout();
        suib.createLabel(Messages.NameWizardPage_CAPTION_RULE_NAME_TEXT, null);
        this.text = suib.createText(this.m_defaultName, "", 0);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() instanceof Text) {
                    Text t = (Text)e.getSource();
                    String text = t.getText();
                    if (names.contains(text)) {
                        NameWizardPage.this.setPageComplete(false);
                        NameWizardPage.this.setErrorMessage(com.jrockit.mc.console.ui.notification.tab.Messages.TriggerSectionPart_DIALOG_RULE_EXISTS_MESSAGE_TEXT);
                    } else {
                        NameWizardPage.this.setPageComplete(true);
                        NameWizardPage.this.setErrorMessage(null);
                        NameWizardPage.this.m_notificationRule.setName(text);
                    }
                }
            }
        });
        suib.layout();
        suib.createLabel(Messages.NameWizardPage_TRIGGER_DESCRIPTION_TEXT, null);
        suib.layout();
        String desc = this.m_notificationRule.getDescription() == null ? "" : this.m_notificationRule.getDescription();
        this.text = suib.createMultiText(desc, "");
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() instanceof Text) {
                    Text t = (Text)e.getSource();
                    NameWizardPage.this.m_notificationRule.setDescription(t.getText());
                }
            }
        });
        suib.layout();
        this.setControl((Control)c);
    }
}

