/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider.bcel;

import com.jrockit.mc.flightrecorder.provider.bcel.Arguments;
import com.jrockit.mc.flightrecorder.provider.bcel.BCELUtilities;
import com.jrockit.mc.flightrecorder.provider.bcel.EventTemplate;
import com.jrockit.mc.flightrecorder.provider.bcel.FieldTemplate;
import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.ClassGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.FieldGen;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionFactory;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.PUTFIELD;
import com.sun.org.apache.bcel.internal.generic.RETURN;
import com.sun.org.apache.bcel.internal.generic.Type;
import java.util.HashMap;
import java.util.Map;

final class EventClassLoader
extends ClassLoader {
    static final JavaClass EVENT_TEMPLATE = Repository.lookupClass(EventTemplate.class);
    static final JavaClass FIELD_TEMPLATE = Repository.lookupClass(FieldTemplate.class);

    EventClassLoader() {
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(className);
        if (clazz == null) {
            clazz = this.findSystemClassSafe(className);
        }
        if (clazz == null && className.startsWith("com.jrockit.mc.flightrecorder.provider.bcel.BCELEvent")) {
            clazz = this.createBCELClass(className);
        }
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Can't find class " + className);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private Class<?> findSystemClassSafe(String name) {
        try {
            return this.findSystemClass(name);
        }
        catch (ClassNotFoundException cce) {
            return null;
        }
    }

    private Class<?> createBCELClass(String name) throws ClassNotFoundException {
        int fieldPrefixBegin = name.indexOf("Field");
        if (fieldPrefixBegin == -1) {
            int fieldCount = Integer.parseInt(name.substring("com.jrockit.mc.flightrecorder.provider.bcel.BCELEvent".length()));
            return this.createClassFromJavaClass(this.createEventJavaClass(fieldCount));
        }
        int fieldCount = Integer.parseInt(name.substring("com.jrockit.mc.flightrecorder.provider.bcel.BCELEvent".length(), fieldPrefixBegin));
        int fieldIndex = Integer.parseInt(name.substring(fieldPrefixBegin + "Field".length()));
        return this.createClassFromJavaClass(this.createFieldJavaClass(fieldCount, fieldIndex));
    }

    private JavaClass createFieldJavaClass(int fieldCount, int fieldIndex) {
        ClassGen cg = new ClassGen(FIELD_TEMPLATE.copy());
        cg.setClassName(BCELUtilities.createFieldClassName(fieldCount, fieldIndex));
        Method[] methodArray = cg.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals("getValue")) {
                cg.replaceMethod(method, this.createGetValueMethod(cg, method, fieldIndex, fieldCount));
            }
            ++n2;
        }
        return cg.getJavaClass();
    }

    private Method createGetValueMethod(ClassGen cg, Method oldMethod, int fieldIndex, int fieldCount) {
        String eventClassName = BCELUtilities.createEventClassName(fieldCount);
        MethodGen methodGen = new MethodGen(oldMethod, cg.getClassName(), cg.getConstantPool());
        InstructionFactory ifa = new InstructionFactory(cg);
        ObjectType destinationType = new ObjectType(eventClassName);
        InstructionList newList = new InstructionList();
        newList.append(new ALOAD(1));
        newList.append(ifa.createCast(Type.OBJECT, destinationType));
        newList.append(ifa.createFieldAccess(eventClassName, "value" + fieldIndex, Type.OBJECT, (short)180));
        newList.append(InstructionFactory.createReturn(Type.OBJECT));
        newList.setPositions();
        methodGen.setInstructionList(newList);
        this.cleanUpMethod(methodGen);
        return methodGen.getMethod();
    }

    private Class<?> createClassFromJavaClass(JavaClass jc) {
        byte[] data = jc.getBytes();
        return this.defineClass(jc.getClassName(), data, 0, data.length);
    }

    private JavaClass createEventJavaClass(int fieldCount) {
        try {
            ClassGen cp = new ClassGen(EVENT_TEMPLATE);
            cp.setClassName(BCELUtilities.createEventClassName(fieldCount));
            this.modifyClass(cp, fieldCount);
            return cp.getJavaClass();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void modifyClass(ClassGen cg, int count) {
        String name = cg.getClassName();
        Map<Integer, Integer> mapping = this.createFieldReferenceMap(cg, name);
        Method[] methodArray = cg.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            cg.replaceMethod(m, this.createModifiedReferenceMethod(cg, m, mapping, count));
            ++n2;
        }
    }

    private Method createModifiedReferenceMethod(ClassGen cg, Method m, Map<Integer, Integer> mapping, int count) {
        MethodGen methGen = new MethodGen(m, cg.getClassName(), cg.getConstantPool());
        InstructionList iList = methGen.getInstructionList();
        InstructionHandle[] instructionHandleArray = iList.getInstructionHandles();
        int n = instructionHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            InstructionHandle ih = instructionHandleArray[n2];
            this.processInstruction(cg, methGen, iList, ih, mapping, count);
            ++n2;
        }
        iList.setPositions();
        methGen.setInstructionList(iList);
        this.cleanUpMethod(methGen);
        return methGen.getMethod();
    }

    private void cleanUpMethod(MethodGen methGen) {
        methGen.setMaxStack();
        methGen.setMaxLocals();
        methGen.removeLineNumbers();
    }

    private void processInstruction(ClassGen cg, MethodGen methodGen, InstructionList iList, InstructionHandle ih, Map<Integer, Integer> mapping, int count) {
        Instruction instruction = ih.getInstruction();
        if (instruction instanceof PUTFIELD) {
            this.replacePutFieldReference(mapping, ih);
        }
        if (instruction instanceof GETFIELD) {
            this.replaceGetFieldReference(mapping, ih);
        }
        if (instruction instanceof RETURN && methodGen.getName().equals("<init>")) {
            this.addAssignments(cg, methodGen, instruction, count);
        }
    }

    private void addAssignments(ClassGen cg, MethodGen m, Instruction instruction, int count) {
        int n = 0;
        while (n < count) {
            this.addAssignment(cg, m, instruction, n, count);
            ++n;
        }
    }

    private void addAssignment(ClassGen cg, MethodGen m, Instruction ret, int index, int count) {
        String fieldName = "value" + index;
        FieldGen fgen = new FieldGen(17, Type.OBJECT, fieldName, cg.getConstantPool());
        cg.addField(fgen.getField());
        InstructionList iList = m.getInstructionList();
        InstructionFactory ifa = new InstructionFactory(cg);
        iList.insert(ret, (Instruction)new ALOAD(0));
        iList.insert(ret, (Instruction)new ALOAD(1));
        iList.insert(ret, (Instruction)ifa.createFieldAccess(Arguments.class.getName(), "values", new ArrayType(Type.OBJECT, 1), (short)180));
        int countPoolIndex = cg.getConstantPool().addInteger(index);
        iList.insert(ret, (Instruction)new LDC(countPoolIndex));
        iList.insert(ret, (Instruction)InstructionFactory.createArrayLoad(Type.OBJECT));
        iList.insert(ret, (Instruction)ifa.createFieldAccess(cg.getClassName(), fieldName, Type.OBJECT, (short)181));
    }

    private Map<Integer, Integer> createFieldReferenceMap(ClassGen cg, String className) {
        ConstantPoolGen cpg = cg.getConstantPool();
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        Field[] fieldArray = cg.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int index = cpg.lookupFieldref(EventTemplate.class.getName(), field.getName(), field.getSignature());
            if (index > 0) {
                int newIndex = cpg.addFieldref(className, field.getName(), field.getSignature());
                mapping.put(index, newIndex);
            }
            ++n2;
        }
        return mapping;
    }

    private void replaceGetFieldReference(Map<Integer, Integer> mapping, InstructionHandle ih) {
        GETFIELD p = (GETFIELD)ih.getInstruction();
        Integer newIndex = mapping.get(p.getIndex());
        if (newIndex != null) {
            ih.setInstruction(new GETFIELD(newIndex));
        }
    }

    private void replacePutFieldReference(Map<Integer, Integer> fieldMappings, InstructionHandle ih) {
        PUTFIELD p = (PUTFIELD)ih.getInstruction();
        Integer newIndex = fieldMappings.get(p.getIndex());
        if (newIndex != null) {
            ih.setInstruction(new PUTFIELD(newIndex));
        }
    }
}

