/*
 * Decompiled with CFR 0.152.
 */
package jdk.packager.services.userjvmoptions;

import java.security.AllPermission;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import jdk.packager.services.UserJvmOptionsService;

public final class LauncherUserJvmOptions
implements UserJvmOptionsService {
    private static final Object semaphore = new Object();

    private static void checkAllPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
    }

    private static native String _getUserJvmOptionDefaultValue(String var0);

    private static native String[] _getUserJvmOptionDefaultKeys();

    private static native String _getUserJvmOptionValue(String var0);

    private static native void _setUserJvmKeysAndValues(String[] var0, String[] var1);

    private static native String[] _getUserJvmOptionKeys();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUserJVMOptions() {
        LauncherUserJvmOptions.checkAllPermissions();
        Object object = semaphore;
        synchronized (object) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string : LauncherUserJvmOptions._getUserJvmOptionKeys()) {
                linkedHashMap.put(string, LauncherUserJvmOptions._getUserJvmOptionValue(string));
            }
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserJVMOptions(Map<String, String> map) {
        LauncherUserJvmOptions.checkAllPermissions();
        Object object = semaphore;
        synchronized (object) {
            LinkedList<String> linkedList = new LinkedList<String>();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new IllegalArgumentException("For Launcher Backed UserJVMOptions keys in the UserJVMOptions map cannot be null.");
                }
                if (entry.getValue() == null) {
                    throw new IllegalArgumentException("For Launcher Backed UserJVMOptions values in the UserJVMOptions map cannot be null.  Keys are removed by absence, not by setting keys to null.");
                }
                linkedList.add(entry.getKey());
                linkedList2.add(entry.getValue());
            }
            LauncherUserJvmOptions._setUserJvmKeysAndValues(linkedList.toArray(new String[linkedList.size()]), linkedList2.toArray(new String[linkedList2.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUserJVMOptionDefaults() {
        LauncherUserJvmOptions.checkAllPermissions();
        Object object = semaphore;
        synchronized (object) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string : LauncherUserJvmOptions._getUserJvmOptionDefaultKeys()) {
                linkedHashMap.put(string, LauncherUserJvmOptions._getUserJvmOptionDefaultValue(string));
            }
            return linkedHashMap;
        }
    }

    static {
        try {
            LauncherUserJvmOptions.checkAllPermissions();
            System.loadLibrary("packager");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

