/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.DataSourceViewProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSourceViewsManager {
    private static final String APP_OVERVIEW_CLASS_workaround = "com.sun.tools.visualvm.application.views.overview.ApplicationOverviewViewProvider";
    private static DataSourceViewsManager sharedInstance;
    private final Map<DataSourceViewProvider, Class<? extends DataSource>> providers = Collections.synchronizedMap(new HashMap());

    public static synchronized DataSourceViewsManager sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DataSourceViewsManager();
        }
        return sharedInstance;
    }

    public void addViewProvider(DataSourceViewProvider provider, Class<? extends DataSource> scope) {
        this.providers.put(provider, scope);
    }

    public void removeViewProvider(DataSourceViewProvider provider) {
        this.providers.remove(provider);
    }

    public boolean canSaveViewsFor(DataSource dataSource, Class<? extends Snapshot> snapshotClass) {
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        if (compatibleProviders.isEmpty()) {
            return false;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!APP_OVERVIEW_CLASS_workaround.equals(compatibleProvider.getClass().getName())) continue;
            return true;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource) || !compatibleProvider.supportsSaveViewFor(dataSource, snapshotClass)) continue;
            return true;
        }
        return false;
    }

    public void saveViewsFor(DataSource dataSource, Snapshot snapshot) {
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource) || !compatibleProvider.supportsSaveViewFor(dataSource, snapshot.getClass())) continue;
            compatibleProvider.viewSaveView(dataSource, snapshot);
        }
    }

    boolean hasViewsFor(DataSource dataSource) {
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        if (compatibleProviders.isEmpty()) {
            return false;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!APP_OVERVIEW_CLASS_workaround.equals(compatibleProvider.getClass().getName())) continue;
            return true;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource)) continue;
            return true;
        }
        return false;
    }

    List<? extends DataSourceView> getViews(DataSource dataSource) {
        ArrayList<DataSourceView> views = new ArrayList<DataSourceView>();
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource)) continue;
            views.add(compatibleProvider.getView(dataSource));
        }
        Collections.sort(views, Positionable.COMPARATOR);
        return views;
    }

    private Set<DataSourceViewProvider> getCompatibleProviders(DataSource dataSource) {
        HashSet<DataSourceViewProvider> compatibleProviders = new HashSet<DataSourceViewProvider>();
        Set<DataSourceViewProvider> providersSet = this.providers.keySet();
        for (DataSourceViewProvider provider : providersSet) {
            if (!this.providers.get(provider).isInstance(dataSource)) continue;
            compatibleProviders.add(provider);
        }
        return compatibleProviders;
    }

    private DataSourceViewsManager() {
    }
}

