/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.MemoryRAFFile;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactoryOn12;
import com.sun.java.help.search.Utilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;

class RAFFileFactory {
    static RAFFileFactory theFactory;
    private int memoryCacheLimit = 10000;
    private static final boolean debug = false;

    private RAFFileFactory() {
    }

    public static synchronized RAFFileFactory create() {
        if (theFactory == null) {
            theFactory = new RAFFileFactory();
        }
        return theFactory;
    }

    private boolean isFileURL(URL uRL) {
        return uRL.getProtocol().equalsIgnoreCase("file");
    }

    public int getMemoryCacheLimit() {
        return this.memoryCacheLimit;
    }

    public void setMemoryCacheLimit(int n) {
        this.memoryCacheLimit = n;
    }

    public synchronized RAFFile get(URL uRL, boolean bl) throws IOException {
        RAFFile rAFFile = null;
        if (this.isFileURL(uRL)) {
            try {
                String string = uRL.getFile();
                string = Utilities.URLDecoder(string);
                rAFFile = new RAFFile(string, bl);
                RAFFileFactory.debug("Opened Dict file with file protocol:" + string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (rAFFile == null) {
            rAFFile = RAFFileFactory.createLocalRAFFile(uRL);
        }
        if (rAFFile == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return rAFFile;
    }

    private static RAFFile createLocalRAFFile(URL uRL) throws IOException {
        RAFFile rAFFile = null;
        URLConnection uRLConnection = uRL.openConnection();
        try {
            Class[] classArray = new Class[]{};
            Method method = URLConnection.class.getMethod("getPermission", classArray);
            rAFFile = RAFFileFactoryOn12.get(uRLConnection);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (rAFFile == null) {
            rAFFile = new MemoryRAFFile(uRLConnection);
            RAFFileFactory.debug("Opening a Dict file in Memory");
        }
        return rAFFile;
    }

    private static void debug(String string) {
    }
}

