/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary.factories;

import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.IPoolFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.JavaThreadFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.MethodFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.OSThreadFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.StackTraceFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.ThreadGroupFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.TypeFactory;
import com.jrockit.mc.flightrecorder.internal.parser.model.ContentType;
import com.jrockit.mc.flightrecorder.internal.parser.model.ProducerDescriptor;
import com.jrockit.mc.flightrecorder.internal.parser.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.provider.Producer;
import java.util.Collection;
import java.util.HashMap;

public final class GlobalObjectPool {
    private final HashMap<String, IPoolFactory> m_factories = new HashMap();
    private final HashMap<Integer, Producer> producers = new HashMap();
    private final boolean showHiddenMethods;

    public GlobalObjectPool(boolean showHiddenMethods) {
        this.showHiddenMethods = showHiddenMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer createProducer(int identifier, String name, String description, String uri) {
        HashMap<Integer, Producer> hashMap = this.producers;
        synchronized (hashMap) {
            Integer key = identifier;
            Producer producer = this.producers.get(key);
            if (producer == null) {
                producer = new Producer(identifier, name, description, uri);
                this.producers.put(identifier, producer);
            }
            return producer;
        }
    }

    public Producer createProducer(ProducerDescriptor descriptor) {
        return this.createProducer(descriptor.getIdentifier(), descriptor.getName(), descriptor.getDescription(), descriptor.getURIString());
    }

    public Collection<Producer> getAllProducers() {
        return this.producers.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPoolFactory getFactory(ContentType contentType) {
        HashMap<String, IPoolFactory> hashMap = this.m_factories;
        synchronized (hashMap) {
            String name = contentType.getName();
            IPoolFactory factory = this.m_factories.get(name);
            if (factory == null && (factory = this.createFactory(contentType)) != null) {
                this.m_factories.put(name, factory);
            }
            return factory;
        }
    }

    private IPoolFactory createFactory(ContentType contentType) {
        String name = contentType.getName();
        ValueDescriptor[] dataStructure = contentType.getDataStructure();
        if ("Method".equals(name)) {
            return new MethodFactory(dataStructure);
        }
        if ("StackTrace".equals(name)) {
            return new StackTraceFactory(dataStructure, this.showHiddenMethods);
        }
        if ("JavaThread".equals(name)) {
            return new JavaThreadFactory(dataStructure);
        }
        if ("Thread".equals(name)) {
            return new OSThreadFactory();
        }
        if ("Class".equals(name)) {
            return new TypeFactory(dataStructure);
        }
        if ("ThreadGroup".equals(name)) {
            return new ThreadGroupFactory(dataStructure);
        }
        return null;
    }
}

