/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.resource;

import com.sun.javafx.tools.resource.ResourceFilter;
import com.sun.javafx.tools.resource.ResourceTraversal;
import java.io.File;

public class PackagerResource {
    private static final ResourceFilter ACCEPT_ALL_FILTER = new ResourceFilter(){

        public boolean descent(File file, String relativePath) {
            return true;
        }

        public boolean accept(File file, String relativePath) {
            return true;
        }
    };
    private final File baseDir;
    private final File file;
    private final String relativePath;

    public PackagerResource(File baseDir, String path) {
        this(baseDir, PackagerResource.createFile(baseDir, path));
    }

    public PackagerResource(File baseDir, File file) {
        File nrmFile = PackagerResource.normalizeFile(file);
        if (nrmFile == null) {
            throw new IllegalArgumentException("Invalid file specified");
        }
        if (baseDir != null) {
            File nrmBaseDir = PackagerResource.normalizeFile(baseDir);
            if (nrmBaseDir == null) {
                throw new IllegalArgumentException("Invalid basedir specified");
            }
            if (nrmFile.equals(nrmBaseDir)) {
                this.file = nrmFile;
                this.baseDir = nrmFile;
                this.relativePath = "";
                return;
            }
            StringBuilder relativePathBuilder = new StringBuilder(nrmFile.getName());
            for (File tempFile = nrmFile.getParentFile(); tempFile != null; tempFile = tempFile.getParentFile()) {
                if (tempFile.equals(nrmBaseDir)) {
                    this.file = nrmFile;
                    this.baseDir = nrmBaseDir;
                    this.relativePath = relativePathBuilder.toString();
                    return;
                }
                relativePathBuilder.insert(0, '/');
                relativePathBuilder.insert(0, tempFile.getName());
            }
        }
        File nrmParentFile = nrmFile.getParentFile();
        this.file = nrmFile;
        this.baseDir = nrmParentFile != null ? nrmParentFile : nrmFile;
        this.relativePath = nrmFile.getName();
    }

    public final File getBaseDir() {
        return this.baseDir;
    }

    public final File getFile() {
        return this.file;
    }

    public final String getRelativePath() {
        return this.relativePath;
    }

    public final boolean traverse(ResourceTraversal resourceTraversal) {
        return this.traverse(resourceTraversal, null);
    }

    public final boolean traverse(ResourceTraversal resourceTraversal, ResourceFilter resourceFilter) {
        return new TraversalOperation(resourceFilter != null ? resourceFilter : ACCEPT_ALL_FILTER, resourceTraversal, this).execute();
    }

    private static File normalizeFile(File inputFile) {
        return PackagerResource.normalizeFileImpl(inputFile.getAbsoluteFile());
    }

    private static File normalizeFileImpl(File inputFile) {
        if (inputFile.getParentFile() == null) {
            return inputFile;
        }
        File partiallyNormalizedFile = PackagerResource.normalizeFileImpl(inputFile.getParentFile());
        if (partiallyNormalizedFile == null) {
            return null;
        }
        String fileName = inputFile.getName();
        if (fileName.equals(".")) {
            return partiallyNormalizedFile;
        }
        if (fileName.equals("..")) {
            return partiallyNormalizedFile.getParentFile();
        }
        return new File(partiallyNormalizedFile, fileName);
    }

    private static File createFile(File baseDir, String path) {
        File testFile = new File(path);
        return testFile.isAbsolute() ? testFile : new File(baseDir.getAbsolutePath(), path);
    }

    private static final class TraversalOperation {
        private final ResourceFilter resourceFilter;
        private final ResourceTraversal resourceTraversal;
        private final PackagerResource rootResource;
        private final StringBuilder relativePathBuilder;

        public TraversalOperation(ResourceFilter resourceFilter, ResourceTraversal resourceTraversal, PackagerResource rootResource) {
            this.resourceFilter = resourceFilter;
            this.resourceTraversal = resourceTraversal;
            this.rootResource = rootResource;
            this.relativePathBuilder = new StringBuilder(rootResource.relativePath);
        }

        public boolean execute() {
            return this.traverse(this.rootResource.file);
        }

        private boolean traverse(File file) {
            String relativePath = this.relativePathBuilder.toString();
            if (this.resourceFilter.accept(file, relativePath) && !this.resourceTraversal.traverse(this.rootResource, file, relativePath)) {
                return false;
            }
            if (!file.isDirectory() || !this.resourceFilter.descent(file, relativePath)) {
                return true;
            }
            int resetLength = this.relativePathBuilder.length();
            for (File nextFile : file.listFiles()) {
                if (resetLength > 0) {
                    this.relativePathBuilder.append('/');
                }
                this.relativePathBuilder.append(nextFile.getName());
                if (!this.traverse(nextFile)) {
                    return false;
                }
                this.relativePathBuilder.setLength(resetLength);
            }
            return true;
        }
    }
}

