/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.UI;
import org.openide.text.AttributedCharacters;

final class ComponentLine {
    private Font myFont;
    private Color myColor;
    private TextLayout myTextLayout;
    private List<Symbol> mySymbols = new ArrayList<Symbol>();

    ComponentLine(AttributedCharacterIterator attributedCharacterIterator, Font font, Color color) {
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            Font font2 = (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
            Color color2 = (Color)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
            this.mySymbols.add(new Symbol(c, this.createFont(font2, font), this.createColor(color2, color)));
            c = attributedCharacterIterator.next();
        }
        this.checkSpaces(font, color);
    }

    ComponentLine(String string, Font font, Color color) {
        for (int i = 0; i < string.length(); ++i) {
            this.mySymbols.add(new Symbol(string.charAt(i), font, color));
        }
        this.checkSpaces(font, color);
    }

    private ComponentLine(List<Symbol> list, Font font, Color color) {
        this.mySymbols = list;
        this.checkSpaces(font, color);
    }

    private Font createFont(Font font, Font font2) {
        if (!Config.getDefault().isUseFont()) {
            return font2;
        }
        String string = font2.getName();
        int n = font2.getSize();
        int n2 = font.getStyle();
        return new Font(string, n2, n);
    }

    private Color createColor(Color color, Color color2) {
        if (Config.getDefault().isUseColor()) {
            return color;
        }
        return color2;
    }

    private void checkSpaces(Font font, Color color) {
        int n;
        this.myFont = font;
        this.myColor = color;
        for (n = this.length() - 1; n >= 1 && this.mySymbols.get(n).getChar() == ' '; --n) {
        }
        this.mySymbols = this.mySymbols.subList(0, n + 1);
        if (this.length() == 0) {
            this.mySymbols.add(new Symbol(' ', font, color));
        }
    }

    void prepend(String string) {
        Font font = this.mySymbols.get(0).getFont();
        String string2 = font.getName();
        int n = font.getSize();
        Font font2 = new Font(string2, 0, n);
        for (int i = string.length() - 1; i >= 0; --i) {
            this.mySymbols.add(0, new Symbol(string.charAt(i), font2, this.myColor));
        }
    }

    boolean isEmpty() {
        for (int i = 0; i < this.length(); ++i) {
            if (this.mySymbols.get(i).getChar() == ' ') continue;
            return false;
        }
        return true;
    }

    int length() {
        return this.mySymbols.size();
    }

    ComponentLine substring(int n, int n2) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.mySymbols.get(i));
        }
        return new ComponentLine(arrayList, this.myFont, this.myColor);
    }

    ComponentLine substring(int n) {
        return this.substring(n, this.mySymbols.size());
    }

    int getAscent() {
        return (int)Math.ceil(this.getTextLayout().getAscent());
    }

    int getDescent() {
        return (int)Math.ceil(this.getTextLayout().getDescent());
    }

    int getLeading() {
        return (int)Math.ceil(this.getTextLayout().getLeading());
    }

    int getWidth() {
        int n = this.getOffset();
        if (n > 0) {
            n = 0;
        }
        return (int)Math.ceil(this.getTextLayout().getBounds().getMaxX() - (double)n);
    }

    int getOffset() {
        return (int)Math.ceil(this.getTextLayout().getBounds().getX());
    }

    void draw(Graphics2D graphics2D, int n, int n2) {
        this.getTextLayout().draw(graphics2D, n, n2);
    }

    private TextLayout getTextLayout() {
        if (this.myTextLayout == null) {
            this.myTextLayout = new TextLayout(this.getIterator(), Config.FONT_RENDER_CONTEXT);
        }
        return this.myTextLayout;
    }

    private AttributedCharacterIterator getIterator() {
        AttributedCharacters attributedCharacters = new AttributedCharacters();
        for (int i = 0; i < this.length(); ++i) {
            attributedCharacters.append(this.mySymbols.get(i).getChar(), this.mySymbols.get(i).getFont(), this.mySymbols.get(i).getColor());
        }
        return attributedCharacters.iterator();
    }

    int lastIndexOf(char c, int n) {
        for (int i = n; i >= 0; --i) {
            if (this.mySymbols.get(i).getChar() != c) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            stringBuilder.append(this.mySymbols.get(i).getChar());
        }
        return stringBuilder.toString();
    }

    void show() {
        for (int i = 0; i < this.length(); ++i) {
            UI.out(this.mySymbols.get(i));
        }
    }

    private static final class Symbol {
        private char myChar;
        private Font myFont;
        private Color myColor;

        Symbol(char c, Font font, Color color) {
            this.myChar = c;
            this.myFont = font;
            this.myColor = color;
        }

        char getChar() {
            return this.myChar;
        }

        Font getFont() {
            return this.myFont;
        }

        Color getColor() {
            return this.myColor;
        }

        void setColor(Color color) {
            this.myColor = color;
        }

        public String toString() {
            return "'" + this.myChar + "' " + this.getString(this.myFont) + " " + this.getString(this.myColor);
        }

        private String getString(Color color) {
            return "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
        }

        private String getString(Font font) {
            String string = "";
            if (font.isBold()) {
                string = string + "bold";
            }
            string = font.isItalic() ? string + " italic" : string + " plain";
            return "[" + font.getName() + ", " + string + ", " + font.getSize() + "]";
        }
    }
}

