/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.RecordingTemplatePart;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

final class AdvancedWizardPage
extends WizardPage
implements IPerformFinishable,
Observer {
    public static final String PAGE_NAME = "advancedOptionWizard";
    private static final int WIZARD_STAGE = 2;
    private RecordingTemplatePart m_recordingTemplateViewer;
    private final RecordingWizardModel m_model;

    protected AdvancedWizardPage(RecordingWizardModel model) {
        super(PAGE_NAME);
        this.m_model = model;
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
    }

    public void createControl(Composite parent) {
        this.setDescription(Messages.ADVANCED_WIZARD_PAGE_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.m_recordingTemplateViewer = new RecordingTemplatePart(this, this.createEditableModel());
        Control settingsTree = this.m_recordingTemplateViewer.createControl(container);
        GridData gd1 = new GridData(4, 4, true, true);
        settingsTree.setLayoutData((Object)gd1);
        this.setControl((Control)container);
    }

    public boolean performFinish() {
        return true;
    }

    private RecordingTemplateModel createEditableModel() {
        IRecordingConfiguration configuration = this.m_model.getCurrentConfigurationAt(2);
        if (configuration == null) {
            return null;
        }
        if (configuration.hasControlElements()) {
            XMLModel ourModel = ((RecordingTemplate)configuration).getXMLModel();
            ourModel.setDirty(false);
            ourModel.addObserver((Observer)this);
        }
        this.setTitle(NLS.bind((String)Messages.ADVANCED_WIZARD_PAGE_TITLE, (Object)configuration.getName()));
        return new RecordingTemplateModel(configuration, this.m_model.getInitialEventTypeSettings(), this.m_model.getEventTypeInfoMap());
    }

    public void setVisible(boolean visible) {
        if (visible && this.m_recordingTemplateViewer != null) {
            this.m_recordingTemplateViewer.setInput(this.createEditableModel());
        }
        super.setVisible(visible);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof XMLModel) {
            IRecordingConfiguration configuration = this.m_model.getCurrentConfigurationAt(2);
            configuration.removeControlElements();
            o.deleteObserver(this);
        }
    }
}

