/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import java.io.Closeable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class UpdateRecordingJob
extends Job {
    private final IRecordingDescriptor m_recordingDescriptor;
    private final Map<String, ?> m_recordingOptions;
    private final IEventSettingsHolder m_recordingSettings;
    private final IServerHandle m_server;

    public UpdateRecordingJob(IServerHandle server, IRecordingDescriptor recordingDescriptor, Map<String, ?> recordingOptions, IEventSettingsHolder recordingSettings) {
        super(NLS.bind((String)Messages.UPDATE_RECORDING_JOB_NAME, (Object)recordingDescriptor.getName()));
        this.m_server = server;
        this.m_recordingDescriptor = recordingDescriptor;
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IConnectionHandle connection = null;
        try {
            connection = this.m_server.connect(this.getName());
            IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class);
            flightRecorderService.updateRecordingOptions(this.m_recordingDescriptor, this.m_recordingOptions);
            flightRecorderService.updateEventSettings(this.m_recordingDescriptor, this.m_recordingSettings);
            iStatus = StatusFactory.createOk((String)Messages.UPDATE_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (Exception e) {
            IStatus iStatus2;
            try {
                iStatus2 = StatusFactory.createErr((String)NLS.bind((String)Messages.UPDATE_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()));
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(connection);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }
}

