/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.preferences;

import com.jrockit.mc.core.security.ActionNotGrantedException;
import com.jrockit.mc.core.security.SecurityException;
import com.jrockit.mc.core.security.SecurityManagerFactory;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.PreferenceToolkit;
import com.jrockit.mc.ui.preferences.Messages;
import com.jrockit.mc.ui.traymanager.TrayManager;
import java.util.logging.Level;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MissionControlPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int GRID_COLUMNS = 3;
    private Combo cipherCombo;

    public MissionControlPage() {
        super(1);
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.MissionControlPage_DESCRIPTION);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("graphics.antialiasing", Messages.MissionControlPage_CAPTION_USE_ANTI_ALIASING, this.getFieldEditorParent()));
        TrayManager tm = UIPlugin.getDefault().getTrayManager();
        if (tm != null && tm.isTraySupported()) {
            this.addField((FieldEditor)new BooleanFieldEditor("tray.minimize.on.close", Messages.MissionControlPage_MINIMIZE_TO_TRAY_ICON_TEXT, this.getFieldEditorParent()));
        }
        this.addField((FieldEditor)new BooleanFieldEditor("threaded.rendering", Messages.MissionControlPage_ENABLE_THREADED_RENDERING_TEXT, this.getFieldEditorParent()));
        Composite renderNote = this.createNoteComposite(this.getFont(), this.getFieldEditorParent(), Messages.MissionControlPage_NOTE_HEADER, Messages.MissionControlPage_RENDERING_NOTE_TEXT);
        PreferenceToolkit.fixGridSpan((Control)renderNote, 3);
        Group accGroup = this.createAccessibilityOptionsGroup(this.getFieldEditorParent());
        PreferenceToolkit.fixGridSpan((Control)accGroup, 3);
        Group secGroup = this.createSecurityGroup(this.getFieldEditorParent());
        PreferenceToolkit.fixGridSpan((Control)secGroup, 3);
    }

    private Group createSecurityGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData groupGridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)groupGridData);
        group.setText(Messages.MissionControlPage_SECURITY_OPTIONS_GROUP_TEXT);
        Composite row1 = new Composite((Composite)group, 0);
        GridLayout row1Layout = new GridLayout();
        row1Layout.numColumns = 2;
        row1.setLayout((Layout)row1Layout);
        Label label = new Label(row1, 1);
        label.setText(Messages.MissionControlPage_CIPHER_LABEL_TEXT);
        this.cipherCombo = new Combo(row1, 8);
        for (String cipher : SecurityManagerFactory.getSecurityManager().getEncryptionCiphers()) {
            this.cipherCombo.add(cipher);
        }
        this.cipherCombo.setText(SecurityManagerFactory.getSecurityManager().getEncryptionCipher());
        Composite row2 = new Composite((Composite)group, 0);
        GridLayout row2Layout = new GridLayout();
        row2Layout.numColumns = 2;
        row2.setLayout((Layout)row2Layout);
        Button changeButton = new Button(row2, 0);
        changeButton.setText(Messages.MissionControlPage_BUTTON_CHANGE_MASTER_PASSWORD);
        changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    SecurityManagerFactory.getSecurityManager().changeMasterPassword();
                }
                catch (ActionNotGrantedException actionNotGrantedException) {
                }
                catch (SecurityException e) {
                    UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not change the master password!", e);
                }
            }
        });
        return group;
    }

    private Group createAccessibilityOptionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData groupGridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)groupGridData);
        group.setText(Messages.MissionControlPage_ACCESSIBILITY_OPTIONS_GROUP_TEXT);
        this.addField((FieldEditor)new BooleanFieldEditor("accessibility.mode", Messages.MissionControlPage_ACCESSIBILITY_MODE_TEXT, this.createIndentedComposite((Composite)group, 0, 0)));
        this.addField((FieldEditor)new BooleanFieldEditor("accessibility.buttonsAsText", Messages.MissionControlPage_ACCESSIBILITY_BUTTONS_AS_TEXT_TEXT, this.createIndentedComposite((Composite)group, 0, 0)));
        this.createNoteComposite(this.getFont(), (Composite)group, Messages.MissionControlPage_NOTE_HEADER, Messages.MissionControlPage_HELP_NOTE_TEXT);
        return group;
    }

    private Composite createIndentedComposite(Composite parent, int horizontalIndent, int verticalIndent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = horizontalIndent;
        gridData.verticalIndent = verticalIndent;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.cipherCombo.setText(SecurityManagerFactory.getSecurityManager().getEncryptionCipher());
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            String cipher = this.cipherCombo.getText();
            String currentCipher = SecurityManagerFactory.getSecurityManager().getEncryptionCipher();
            if (cipher != null && cipher.trim().length() > 0 && !cipher.equals(currentCipher)) {
                SecurityManagerFactory.getSecurityManager().setEncryptionCipher(cipher);
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return super.performOk();
    }
}

