/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.formpage.internal;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.formpage.FormPageContributionGroup;
import com.jrockit.mc.ui.formpage.FormPageContributionItem;
import com.jrockit.mc.ui.formpage.IFormPageSelectorPart;
import com.jrockit.mc.ui.formpage.internal.AccessibilityToolbarPart;
import com.jrockit.mc.ui.formpage.internal.ButtonToolbarSelector;
import com.jrockit.mc.ui.formpage.internal.FormPageContributionToolkit;
import com.jrockit.mc.ui.formpage.internal.MCFormEditor;
import com.jrockit.mc.ui.idesupport.StandardPerspective;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class ToolbarFormEditor
extends MCFormEditor {
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    private String m_navigatorPosition = "left";
    private String m_tabPosition = "bottom";
    private IFormPageSelectorPart m_selectorPart;
    private List<FormPageContributionItem> m_selectedItems = Collections.emptyList();
    private FormPageContributionGroup m_selectedGroup;
    private final Map<FormPageContributionGroup, FormPageContributionItem> m_activeForGroupMap = new HashMap<FormPageContributionGroup, FormPageContributionItem>();
    private Composite m_tabParent;

    public int addPage(IFormPage page) throws PartInitException {
        throw new AddPageNotSupportedException();
    }

    public void addPage(int index, IFormPage page) throws PartInitException {
        throw new AddPageNotSupportedException();
    }

    public void setFocus() {
        if (!this.m_selectorPart.tryFocus()) {
            this.getContainer().setFocus();
        }
    }

    public int addPage(Control control) {
        throw new AddPageNotSupportedException();
    }

    public void addPage(int index, Control control) {
        throw new AddPageNotSupportedException();
    }

    public int addPage(IEditorPart editor, IEditorInput input) {
        throw new AddPageNotSupportedException();
    }

    public void addPage(int index, IEditorPart editor, IEditorInput input) {
        throw new AddPageNotSupportedException();
    }

    public final void addPages() {
        throw new AddPageNotSupportedException();
    }

    protected int getAbsolutPageIndex(FormPageContributionItem item) {
        int index = 0;
        while (index < this.pages.size()) {
            if (this.pages.get(index) == item.getFormPage()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected abstract void initializeFormPageContributions();

    public void addFormPageContributionItem(FormPageContributionItem item, IEditorInput editorInput) throws PartInitException {
        int index = this.pages.size();
        this.addPageSafe(index, item.getFormPage(), this.getEditorInput());
        this.setPageImage(index, item.getIcon());
        this.setPageText(index, item.getLabel());
        ScrolledForm form = item.getFormPage().getManagedForm().getForm();
        form.setText(item.getLabel());
        form.setImage(item.getIcon());
    }

    private void addPageSafe(int index, IFormPage page, IEditorInput editorInput) {
        try {
            super.addPage(index, (IEditorPart)page, editorInput);
        }
        catch (PartInitException e) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not add a FormPageContribution of class " + page.getClass().getName() + ". Page will be removed.", e);
        }
    }

    protected void configurePage(int index, IFormPage page) throws PartInitException {
        this.setPageText(index, page.getTitle());
        page.setIndex(index);
        this.registerPage(index, page);
    }

    private void registerPage(int index, Object page) throws PartInitException {
        if (!this.pages.contains(page)) {
            if (index == -1) {
                this.pages.add(page);
            } else {
                this.pages.add(index, page);
            }
        }
    }

    public void dispose() {
        IFormPage[] formPages;
        IFormPage[] iFormPageArray = formPages = this.pages.toArray(new IFormPage[this.pages.size()]);
        int n = formPages.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage formPage = iFormPageArray[n2];
            try {
                formPage.dispose();
            }
            catch (Exception e) {
                UIPlugin.getDefault().getLogger().log(Level.WARNING, "Could not dispose form page!", e);
            }
            this.disposeSite(formPage.getSite());
            ++n2;
        }
        if (this.getToolkit() != null) {
            this.getToolkit().dispose();
        }
        this.m_activeForGroupMap.clear();
        this.m_selectedItems = null;
        this.m_selectorPart = null;
        this.updateClosedWithEditor();
    }

    private void updateClosedWithEditor() {
        IWorkbenchPage p = this.getSite().getWorkbenchWindow().getActivePage();
        StandardPerspective.setClosedWithEditor(p == null);
    }

    protected void disposeSite(final IWorkbenchPartSite site) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                if (site instanceof MultiPageEditorSite) {
                    ((MultiPageEditorSite)site).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    protected void setPageText(int pageIndex, String text) {
        this.getMultiPageItem(pageIndex).setText(text == null ? "" : text);
    }

    private CTabItem createMultiPageItem(int index, Control control, String title, Image image) {
        CTabItem item = new CTabItem(this.getMultiPageTabFolder(), 0, index);
        item.setControl(control);
        item.setText(title == null ? "" : title);
        item.setImage(image);
        return item;
    }

    private void setMultiPageActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getMultiPageTabFolder().setSelection(pageIndex);
        this.pageChange(pageIndex);
    }

    private void removeMultiPageItem(int pageIndex) {
        CTabItem item = this.getMultiPageItem(pageIndex);
        item.dispose();
    }

    private CTabItem getMultiPageItem(int pageIndex) {
        return this.getMultiPageTabFolder().getItem(pageIndex);
    }

    private CTabFolder getMultiPageTabFolder() {
        return (CTabFolder)this.getContainer();
    }

    protected void createPages() {
        if (TOP.equals(this.getTabPosition())) {
            try {
                Field f = MultiPageEditorPart.class.getDeclaredField("container");
                f.setAccessible(true);
                Composite container = (Composite)f.get((Object)this);
                container.dispose();
                container = this.createTopContainer(this.m_tabParent, 0x800080);
                f.set((Object)this, container);
            }
            catch (Exception e) {
                UIPlugin.getDefault().getLogger().warning("Could not access CTabFolder using reflection. Will use default CTabFolder at bottom.");
            }
        }
        this.createFormPageContributionItems();
    }

    private String getTabPosition() {
        return this.m_tabPosition;
    }

    private CTabFolder createTopContainer(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        final CTabFolder newContainer = new CTabFolder(parent, style);
        newContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = newContainer.indexOf((CTabItem)e.item);
                ToolbarFormEditor.this.pageChange(newPageIndex);
            }
        });
        return newContainer;
    }

    protected Composite createPageContainer(Composite parent) {
        Composite container = super.createPageContainer(parent);
        if (LEFT.equals(this.getNavigatorPosition()) || TOP.equals(this.getNavigatorPosition())) {
            this.createSelector(container);
            this.createSash(parent);
            this.m_tabParent = this.createMain(parent);
        }
        if (RIGHT.equals(this.getNavigatorPosition()) || BOTTOM.equals(this.getNavigatorPosition())) {
            this.m_tabParent = this.createMain(parent);
            this.createSash(parent);
            this.createSelector(container);
        }
        container.setLayout((Layout)this.createPageContainerLayout());
        return this.m_tabParent;
    }

    private void createSash(Composite parent) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        if (this.isHorizontal()) {
            gd.heightHint = 1;
            gd.grabExcessHorizontalSpace = true;
        } else {
            gd.widthHint = 1;
            gd.grabExcessVerticalSpace = true;
        }
        Composite sash = new Composite(parent, 0);
        sash.setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
        sash.setLayoutData((Object)gd);
    }

    private GridLayout createPageContainerLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.isHorizontal() ? 1 : 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        return layout;
    }

    boolean isHorizontal() {
        return this.getNavigatorPosition().equals(TOP) || this.getNavigatorPosition().equals(BOTTOM);
    }

    private Composite createMain(Composite parent) {
        GridData gd2 = new GridData(4, 4, true, true);
        Composite main = this.getToolkit().createComposite(parent);
        main.setLayoutData((Object)gd2);
        return main;
    }

    private void createSelector(Composite container) {
        this.m_selectorPart = UIPlugin.getDefault().getAccessibilityMode() ? new AccessibilityToolbarPart() : new ButtonToolbarSelector(this.isHorizontal(), this.getToolkit(), container, new Runnable(){

            @Override
            public void run() {
                ToolbarFormEditor.this.show(ToolbarFormEditor.this.m_selectorPart.getActive(), false);
            }
        });
    }

    public void show(FormPageContributionGroup group, boolean forceUpdate) {
        if (!group.equals(this.m_selectedGroup) || forceUpdate) {
            if (this.m_activeForGroupMap.size() > 15) {
                this.m_activeForGroupMap.remove(this.m_activeForGroupMap.keySet().iterator().next());
            }
            if (this.m_selectedGroup != null) {
                this.m_activeForGroupMap.put(this.m_selectedGroup, this.getActiveContributionItem());
            }
            int oldPageCount = this.getPageCount();
            List<FormPageContributionItem> formPageContributionItems = FormPageContributionToolkit.flatten(group.getChildren(), FormPageContributionItem.class, Integer.MAX_VALUE, true);
            FormPageContributionItem activeItem = this.m_activeForGroupMap.get(group);
            if (activeItem == null && !formPageContributionItems.isEmpty()) {
                activeItem = formPageContributionItems.iterator().next();
            }
            int index = 0;
            int activeInGroupLastTime = 0;
            for (FormPageContributionItem item : formPageContributionItems) {
                IFormPage info;
                if (item == activeItem) {
                    activeInGroupLastTime = index;
                }
                if ((info = item.getFormPage()).getPartControl() == null) {
                    throw new IllegalStateException("You can't call show before the contributions has been initialized.");
                }
                this.createMultiPageItem(oldPageCount + index, (Control)info.getPartControl().getParent(), item.getLabel(), item.getIcon());
                this.setPageText(oldPageCount + index, item.getLabel());
                ++index;
            }
            int currentActive = super.getActivePage();
            int pickIndex = 0;
            int n = 0;
            while (n < oldPageCount) {
                if (n != currentActive) {
                    this.removeMultiPageItem(pickIndex);
                } else {
                    pickIndex = 1;
                }
                ++n;
            }
            this.m_selectedItems = formPageContributionItems;
            this.m_selectedGroup = group;
            if (currentActive != -1) {
                this.removeMultiPageItem(0);
            }
            int activePageIndex = this.getPageIndexFromTabIndex(activeInGroupLastTime);
            this.setActivePage(activePageIndex);
        }
    }

    private FormPageContributionItem getActiveContributionItem() {
        int selectedIndex = this.getMultiPageTabFolder().getSelectionIndex();
        if (selectedIndex >= 0 && selectedIndex < this.getMultiPageTabFolder().getItemCount() && selectedIndex < this.m_selectedItems.size()) {
            return this.m_selectedItems.get(selectedIndex);
        }
        return null;
    }

    public List<IFormPage> getPages() {
        ArrayList<IFormPage> list = new ArrayList<IFormPage>();
        for (FormPageContributionItem i : this.m_selectedItems) {
            list.add(i.getFormPage());
        }
        return list;
    }

    protected void setTabPosition(String position) {
        if (TOP.equals(position) || BOTTOM.equals(position)) {
            this.m_tabPosition = position;
        }
    }

    public IFormPageSelectorPart getSelectorPart() {
        return this.m_selectorPart;
    }

    protected void setNavigatorPosition(String position) {
        if (TOP.equals(position) || BOTTOM.equals(position) || LEFT.equals(position) || RIGHT.equals(position)) {
            this.m_navigatorPosition = position;
        }
    }

    private String getNavigatorPosition() {
        return this.m_navigatorPosition;
    }

    protected final void createFormPageContributionItems() {
        this.initializeFormPageContributions();
        this.getToolkit().adapt((Composite)this.getMultiPageTabFolder());
        this.getMultiPageTabFolder().setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BG"));
    }

    private int getTabIndexFromPageIndex(int pageIndex) {
        int index = 0;
        IFormPage fp = (IFormPage)this.pages.get(pageIndex);
        for (FormPageContributionItem fpci : this.m_selectedItems) {
            if (fpci.getFormPage() == fp) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    private int getPageIndexFromTabIndex(int tabIndex) {
        if (tabIndex >= 0 && tabIndex < this.m_selectedItems.size()) {
            if (this.m_selectedItems.isEmpty()) {
                return 0;
            }
            IFormPage fpg = this.m_selectedItems.get(tabIndex).getFormPage();
            int index = 0;
            while (index < this.pages.size()) {
                if (this.pages.get(index) == fpg) {
                    return index;
                }
                ++index;
            }
        }
        return 0;
    }

    protected void setActivePage(int pageIndex) {
        IFormPage activePage = this.getPageFromIndex(pageIndex);
        if (activePage != null) {
            activePage.setActive(true);
        }
        this.setMultiPageActivePage(this.getTabIndexFromPageIndex(pageIndex));
        this.updateActionBarContributor(pageIndex);
    }

    private IFormPage getPageFromIndex(int pageIndex) {
        if (this.pages.size() > pageIndex && this.pages.get(pageIndex) instanceof IFormPage) {
            return (IFormPage)this.pages.get(pageIndex);
        }
        return null;
    }

    public IFormPage setActivePage(String pageId) {
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage fpage;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && pageId.equals((fpage = (IFormPage)page).getId())) {
                this.setActivePage(i);
                return fpage;
            }
            ++i;
        }
        return null;
    }

    private void updatePageIndices() {
        int i = 0;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                IFormPage fpage = (IFormPage)page;
                fpage.setIndex(i);
            }
            ++i;
        }
    }

    public void removePage(int pageIndex) {
        IFormPage fpage = (IFormPage)this.pages.get(pageIndex);
        fpage.dispose();
        this.pages.remove(pageIndex);
        this.updatePageIndices();
    }

    public void removeMultiPage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getEditor(pageIndex);
        CTabItem item = this.getMultiPageItem(pageIndex);
        Control pageControl = item.getControl();
        item.dispose();
        if (pageControl != null) {
            pageControl.dispose();
        }
    }

    public final int getActivePage() {
        return this.getPageIndexFromTabIndex(super.getActivePage());
    }

    public IFormPage getActivePageInstance() {
        Object page;
        int index = this.getActivePage();
        if (index >= 0 && index < this.pages.size() && (page = this.pages.get(index)) instanceof IFormPage) {
            return (IFormPage)page;
        }
        return null;
    }

    protected final IEditorPart getEditor(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.pages.size()) {
            return pageIndex < this.pages.size() ? (IEditorPart)this.pages.get(pageIndex) : null;
        }
        return null;
    }

    protected final void pageChange(int tabIndex) {
        int result = this.getPageIndexFromTabIndex(tabIndex);
        if (result != -1) {
            this.updateLayoutDeferred(this.getPageFromIndex(result));
            super.pageChange(result);
        }
    }

    private void updateLayoutDeferred(IFormPage selectedPage) {
        for (Object fp : this.pages) {
            Composite form;
            boolean layoutDeferred;
            boolean isSelected;
            if (!(fp instanceof IFormPage) || !(((IFormPage)fp).getPartControl() instanceof Composite) || (isSelected = fp == selectedPage) != (layoutDeferred = (form = (Composite)((IFormPage)fp).getPartControl()).isLayoutDeferred())) continue;
            form.setLayoutDeferred(!layoutDeferred);
        }
    }

    private static final class AddPageNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = -6808162764192677901L;

        public AddPageNotSupportedException() {
            super("AddPage not supported. Use addCategory and addCategoryPage instead.");
        }
    }
}

