/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.checkedstate;

import com.jrockit.mc.ui.checkedstate.CheckedStateManager;
import com.jrockit.mc.ui.checkedstate.ICheckedElement;
import com.jrockit.mc.ui.checkedstate.ICheckedStateModifierProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;

public class ContainerProviderModifier
implements ICheckedStateModifierProvider {
    private final Map<Object, ICheckedElement> m_cachedStateMap = new HashMap<Object, ICheckedElement>();
    private final CheckedStateManager m_checkStateManager;

    public ContainerProviderModifier(CheckedStateManager manager) {
        this.m_checkStateManager = manager;
    }

    @Override
    public void checkStateChanged(CheckboxTreeViewer viewer) {
        this.m_cachedStateMap.clear();
        ITreeContentProvider itcp = this.getTreeContentProvider();
        if (itcp != null) {
            Object[] elements;
            Object[] objectArray = elements = itcp.getElements(viewer.getInput());
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)viewer, null, element)) {
                    this.createStateAndStore(itcp, element);
                }
                ++n2;
            }
        }
    }

    @Override
    public Boolean isChecked(Object element) {
        ICheckedElement state = this.m_cachedStateMap.get(element);
        if (state != null) {
            return state.isChecked();
        }
        return null;
    }

    @Override
    public Boolean isGreyed(Object element) {
        ICheckedElement state = this.m_cachedStateMap.get(element);
        if (state != null) {
            return state.isGreyed();
        }
        return null;
    }

    @Override
    public boolean setChecked(Object element, boolean checked) {
        ITreeContentProvider itp = this.getTreeContentProvider();
        if (itp != null) {
            Object[] treeChildren;
            Object[] objectArray = treeChildren = itp.getChildren(element);
            int n = treeChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object element2 = objectArray[n2];
                if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)this.m_checkStateManager.getViewer(), element, element2)) {
                    this.m_checkStateManager.setChecked(element2, checked);
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private ICheckedElement createStateAndStore(ITreeContentProvider itcp, Object element) {
        Object[] elements = itcp.getChildren(element);
        ICheckedElement state = elements.length == 0 ? this.createLeafState(element) : this.createContainerState(itcp, element, elements);
        this.m_cachedStateMap.put(element, state);
        return state;
    }

    private ICheckedElement createLeafState(Object element) {
        return new CachedCheckableElement(this.m_checkStateManager.getChecked(element), this.m_checkStateManager.getGreyed(element));
    }

    private ICheckedElement createContainerState(ITreeContentProvider itcp, Object parent, Object[] elements) {
        Object[] children = itcp.getChildren(parent);
        int checked = 0;
        int total = 0;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)this.m_checkStateManager.getViewer(), parent, element)) {
                ICheckedElement state = this.createStateAndStore(itcp, element);
                if (state != null) {
                    if (Boolean.TRUE.equals(state.isGreyed())) {
                        return new CachedCheckableElement(Boolean.TRUE, Boolean.TRUE);
                    }
                    if (Boolean.TRUE.equals(state.isChecked())) {
                        ++checked;
                    }
                }
                ++total;
            }
            ++n2;
        }
        return new CachedCheckableElement(checked > 0, checked > 0 && checked < total);
    }

    private ITreeContentProvider getTreeContentProvider() {
        IContentProvider provider = this.m_checkStateManager.getViewer().getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            return (ITreeContentProvider)provider;
        }
        return null;
    }

    private static final class CachedCheckableElement
    implements ICheckedElement {
        private final Boolean m_checked;
        private final Boolean m_grayed;

        public CachedCheckableElement(Boolean checked, Boolean grayed) {
            this.m_checked = checked;
            this.m_grayed = grayed;
        }

        @Override
        public Boolean isChecked() {
            return this.m_checked;
        }

        @Override
        public Boolean isGreyed() {
            return this.m_grayed;
        }

        @Override
        public void setChecked(boolean checked) {
        }
    }
}

